package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * IP Adjacency
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * case ip-adjacency {
 *   when "../nai-type = 'ipv4-adjacency' or ../nai-type = 'ipv6-adjacency'";
 *   leaf local-ip-address {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf remote-ip-address {
 *     type inet:ip-address-no-zone;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface IpAdjacency
    extends
    Nai,
    DataObject,
    Augmentable<IpAdjacency>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ip-adjacency");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpAdjacency> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpAdjacency.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpAdjacency obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getLocalIpAddress());
        result = prime * result + Objects.hashCode(obj.getRemoteIpAddress());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpAdjacency thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpAdjacency.class, obj);
        return other != null
            && Objects.equals(thisObj.getLocalIpAddress(), other.getLocalIpAddress())
            && Objects.equals(thisObj.getRemoteIpAddress(), other.getRemoteIpAddress())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpAdjacency obj) {
        final var helper = MoreObjects.toStringHelper("IpAdjacency");
        CodeHelpers.appendValue(helper, "localIpAddress", obj.getLocalIpAddress());
        CodeHelpers.appendValue(helper, "remoteIpAddress", obj.getRemoteIpAddress());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return localIpAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} localIpAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getLocalIpAddress();
    
    /**
     * Return localIpAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} localIpAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if localIpAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireLocalIpAddress() {
        return CodeHelpers.require(getLocalIpAddress(), "localipaddress");
    }
    
    /**
     * Return remoteIpAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} remoteIpAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getRemoteIpAddress();
    
    /**
     * Return remoteIpAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} remoteIpAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteIpAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireRemoteIpAddress() {
        return CodeHelpers.require(getRemoteIpAddress(), "remoteipaddress");
    }

}

