package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * IP Node ID
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * case ip-node-id {
 *   when "../nai-type = 'ipv4-node-id' or ../nai-type = 'ipv6-node-id'";
 *   leaf ip-address {
 *     type inet:ip-address-no-zone;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface IpNodeId
    extends
    Nai,
    DataObject,
    Augmentable<IpNodeId>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ip-node-id");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpNodeId> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpNodeId.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpNodeId obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getIpAddress());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpNodeId thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpNodeId.class, obj);
        return other != null
            && Objects.equals(thisObj.getIpAddress(), other.getIpAddress())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull IpNodeId obj) {
        final var helper = MoreObjects.toStringHelper("IpNodeId");
        CodeHelpers.appendValue(helper, "ipAddress", obj.getIpAddress());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return ipAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} ipAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getIpAddress();
    
    /**
     * Return ipAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} ipAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if ipAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireIpAddress() {
        return CodeHelpers.require(getIpAddress(), "ipaddress");
    }

}

