package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * IPv6 adjacency with link-local IPv6 addresses
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * case ipv6-local {
 *   when "../nai-type = 'ipv6-local'";
 *   leaf local-ipv6-address {
 *     type inet:ipv6-address-no-zone;
 *   }
 *   leaf local-id {
 *     type uint32;
 *   }
 *   leaf remote-ipv6-address {
 *     type inet:ipv6-address-no-zone;
 *   }
 *   leaf remote-id {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Ipv6Local
    extends
    Nai,
    DataObject,
    Augmentable<Ipv6Local>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ipv6-local");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.Ipv6Local> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.Ipv6Local.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull Ipv6Local obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getLocalId());
        result = prime * result + Objects.hashCode(obj.getLocalIpv6Address());
        result = prime * result + Objects.hashCode(obj.getRemoteId());
        result = prime * result + Objects.hashCode(obj.getRemoteIpv6Address());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull Ipv6Local thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.Ipv6Local.class, obj);
        return other != null
            && Objects.equals(thisObj.getLocalId(), other.getLocalId())
            && Objects.equals(thisObj.getRemoteId(), other.getRemoteId())
            && Objects.equals(thisObj.getLocalIpv6Address(), other.getLocalIpv6Address())
            && Objects.equals(thisObj.getRemoteIpv6Address(), other.getRemoteIpv6Address())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull Ipv6Local obj) {
        final var helper = MoreObjects.toStringHelper("Ipv6Local");
        CodeHelpers.appendValue(helper, "localId", obj.getLocalId());
        CodeHelpers.appendValue(helper, "localIpv6Address", obj.getLocalIpv6Address());
        CodeHelpers.appendValue(helper, "remoteId", obj.getRemoteId());
        CodeHelpers.appendValue(helper, "remoteIpv6Address", obj.getRemoteIpv6Address());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return localIpv6Address, or {@code null} if it is not present.
     *
     * @return {@code Ipv6AddressNoZone} localIpv6Address, or {@code null} if it is not present.
     *
     */
    Ipv6AddressNoZone getLocalIpv6Address();
    
    /**
     * Return localIpv6Address, guaranteed to be non-null.
     *
     * @return {@code Ipv6AddressNoZone} localIpv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if localIpv6Address is not present
     *
     */
    default @NonNull Ipv6AddressNoZone requireLocalIpv6Address() {
        return CodeHelpers.require(getLocalIpv6Address(), "localipv6address");
    }
    
    /**
     * Return localId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} localId, or {@code null} if it is not present.
     *
     */
    Uint32 getLocalId();
    
    /**
     * Return localId, guaranteed to be non-null.
     *
     * @return {@code Uint32} localId, guaranteed to be non-null.
     * @throws NoSuchElementException if localId is not present
     *
     */
    default @NonNull Uint32 requireLocalId() {
        return CodeHelpers.require(getLocalId(), "localid");
    }
    
    /**
     * Return remoteIpv6Address, or {@code null} if it is not present.
     *
     * @return {@code Ipv6AddressNoZone} remoteIpv6Address, or {@code null} if it is not present.
     *
     */
    Ipv6AddressNoZone getRemoteIpv6Address();
    
    /**
     * Return remoteIpv6Address, guaranteed to be non-null.
     *
     * @return {@code Ipv6AddressNoZone} remoteIpv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteIpv6Address is not present
     *
     */
    default @NonNull Ipv6AddressNoZone requireRemoteIpv6Address() {
        return CodeHelpers.require(getRemoteIpv6Address(), "remoteipv6address");
    }
    
    /**
     * Return remoteId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} remoteId, or {@code null} if it is not present.
     *
     */
    Uint32 getRemoteId();
    
    /**
     * Return remoteId, guaranteed to be non-null.
     *
     * @return {@code Uint32} remoteId, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteId is not present
     *
     */
    default @NonNull Uint32 requireRemoteId() {
        return CodeHelpers.require(getRemoteId(), "remoteid");
    }

}

