package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Ipv6Local} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ipv6Local createIpv6Local(int fooXyzzy, int barBaz) {
 *         return new Ipv6LocalBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ipv6Local, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ipv6Local
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv6LocalBuilder {

    private Uint32 _localId;
    private Ipv6AddressNoZone _localIpv6Address;
    private Uint32 _remoteId;
    private Ipv6AddressNoZone _remoteIpv6Address;


    Map<Class<? extends Augmentation<Ipv6Local>>, Augmentation<Ipv6Local>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public Ipv6LocalBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Ipv6Local}.
     *
     * @param base Ipv6Local from which the builder should be initialized
     */
    public Ipv6LocalBuilder(Ipv6Local base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._localId = base.getLocalId();
        this._localIpv6Address = base.getLocalIpv6Address();
        this._remoteId = base.getRemoteId();
        this._remoteIpv6Address = base.getRemoteIpv6Address();
    }



    /**
     * Return current value associated with the property corresponding to {@link Ipv6Local#getLocalId()}.
     *
     * @return current value
     */
    public Uint32 getLocalId() {
        return _localId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ipv6Local#getLocalIpv6Address()}.
     *
     * @return current value
     */
    public Ipv6AddressNoZone getLocalIpv6Address() {
        return _localIpv6Address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ipv6Local#getRemoteId()}.
     *
     * @return current value
     */
    public Uint32 getRemoteId() {
        return _remoteId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ipv6Local#getRemoteIpv6Address()}.
     *
     * @return current value
     */
    public Ipv6AddressNoZone getRemoteIpv6Address() {
        return _remoteIpv6Address;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Ipv6Local>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Ipv6Local#getLocalId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Ipv6LocalBuilder setLocalId(final Uint32 value) {
        this._localId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ipv6Local#getLocalIpv6Address()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Ipv6LocalBuilder setLocalIpv6Address(final Ipv6AddressNoZone value) {
        this._localIpv6Address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ipv6Local#getRemoteId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Ipv6LocalBuilder setRemoteId(final Uint32 value) {
        this._remoteId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ipv6Local#getRemoteIpv6Address()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Ipv6LocalBuilder setRemoteIpv6Address(final Ipv6AddressNoZone value) {
        this._remoteIpv6Address = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Ipv6LocalBuilder addAugmentation(Augmentation<Ipv6Local> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Ipv6LocalBuilder removeAugmentation(Class<? extends Augmentation<Ipv6Local>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Ipv6Local} instance.
     *
     * @return A new {@link Ipv6Local} instance.
     */
    public @NonNull Ipv6Local build() {
        return new Ipv6LocalImpl(this);
    }

    private static final class Ipv6LocalImpl
        extends AbstractAugmentable<Ipv6Local>
        implements Ipv6Local {
    
        private final Uint32 _localId;
        private final Ipv6AddressNoZone _localIpv6Address;
        private final Uint32 _remoteId;
        private final Ipv6AddressNoZone _remoteIpv6Address;
    
        Ipv6LocalImpl(Ipv6LocalBuilder base) {
            super(base.augmentation);
            this._localId = base.getLocalId();
            this._localIpv6Address = base.getLocalIpv6Address();
            this._remoteId = base.getRemoteId();
            this._remoteIpv6Address = base.getRemoteIpv6Address();
        }
    
        @Override
        public Uint32 getLocalId() {
            return _localId;
        }
        
        @Override
        public Ipv6AddressNoZone getLocalIpv6Address() {
            return _localIpv6Address;
        }
        
        @Override
        public Uint32 getRemoteId() {
            return _remoteId;
        }
        
        @Override
        public Ipv6AddressNoZone getRemoteIpv6Address() {
            return _remoteIpv6Address;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ipv6Local.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ipv6Local.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ipv6Local.bindingToString(this);
        }
    }
}
