package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Unnumbered Adjacency with IPv4 NodeIDs
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * case unnumbered-adjacency {
 *   when "../nai-type = 'unnumbered'";
 *   leaf local-node-id {
 *     type uint32;
 *   }
 *   leaf local-interface-id {
 *     type uint32;
 *   }
 *   leaf remote-node-id {
 *     type uint32;
 *   }
 *   leaf remote-interface-id {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface UnnumberedAdjacency
    extends
    Nai,
    DataObject,
    Augmentable<UnnumberedAdjacency>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("unnumbered-adjacency");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.UnnumberedAdjacency> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.UnnumberedAdjacency.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull UnnumberedAdjacency obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getLocalInterfaceId());
        result = prime * result + Objects.hashCode(obj.getLocalNodeId());
        result = prime * result + Objects.hashCode(obj.getRemoteInterfaceId());
        result = prime * result + Objects.hashCode(obj.getRemoteNodeId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull UnnumberedAdjacency thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.UnnumberedAdjacency.class, obj);
        return other != null
            && Objects.equals(thisObj.getLocalInterfaceId(), other.getLocalInterfaceId())
            && Objects.equals(thisObj.getLocalNodeId(), other.getLocalNodeId())
            && Objects.equals(thisObj.getRemoteInterfaceId(), other.getRemoteInterfaceId())
            && Objects.equals(thisObj.getRemoteNodeId(), other.getRemoteNodeId())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.@NonNull UnnumberedAdjacency obj) {
        final var helper = MoreObjects.toStringHelper("UnnumberedAdjacency");
        CodeHelpers.appendValue(helper, "localInterfaceId", obj.getLocalInterfaceId());
        CodeHelpers.appendValue(helper, "localNodeId", obj.getLocalNodeId());
        CodeHelpers.appendValue(helper, "remoteInterfaceId", obj.getRemoteInterfaceId());
        CodeHelpers.appendValue(helper, "remoteNodeId", obj.getRemoteNodeId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return localNodeId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} localNodeId, or {@code null} if it is not present.
     *
     */
    Uint32 getLocalNodeId();
    
    /**
     * Return localNodeId, guaranteed to be non-null.
     *
     * @return {@code Uint32} localNodeId, guaranteed to be non-null.
     * @throws NoSuchElementException if localNodeId is not present
     *
     */
    default @NonNull Uint32 requireLocalNodeId() {
        return CodeHelpers.require(getLocalNodeId(), "localnodeid");
    }
    
    /**
     * Return localInterfaceId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} localInterfaceId, or {@code null} if it is not present.
     *
     */
    Uint32 getLocalInterfaceId();
    
    /**
     * Return localInterfaceId, guaranteed to be non-null.
     *
     * @return {@code Uint32} localInterfaceId, guaranteed to be non-null.
     * @throws NoSuchElementException if localInterfaceId is not present
     *
     */
    default @NonNull Uint32 requireLocalInterfaceId() {
        return CodeHelpers.require(getLocalInterfaceId(), "localinterfaceid");
    }
    
    /**
     * Return remoteNodeId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} remoteNodeId, or {@code null} if it is not present.
     *
     */
    Uint32 getRemoteNodeId();
    
    /**
     * Return remoteNodeId, guaranteed to be non-null.
     *
     * @return {@code Uint32} remoteNodeId, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteNodeId is not present
     *
     */
    default @NonNull Uint32 requireRemoteNodeId() {
        return CodeHelpers.require(getRemoteNodeId(), "remotenodeid");
    }
    
    /**
     * Return remoteInterfaceId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} remoteInterfaceId, or {@code null} if it is not present.
     *
     */
    Uint32 getRemoteInterfaceId();
    
    /**
     * Return remoteInterfaceId, guaranteed to be non-null.
     *
     * @return {@code Uint32} remoteInterfaceId, guaranteed to be non-null.
     * @throws NoSuchElementException if remoteInterfaceId is not present
     *
     */
    default @NonNull Uint32 requireRemoteInterfaceId() {
        return CodeHelpers.require(getRemoteInterfaceId(), "remoteinterfaceid");
    }

}

