package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link UnnumberedAdjacency} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     UnnumberedAdjacency createUnnumberedAdjacency(int fooXyzzy, int barBaz) {
 *         return new UnnumberedAdjacencyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of UnnumberedAdjacency, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see UnnumberedAdjacency
 *
 */
@Generated("mdsal-binding-generator")
public class UnnumberedAdjacencyBuilder {

    private Uint32 _localInterfaceId;
    private Uint32 _localNodeId;
    private Uint32 _remoteInterfaceId;
    private Uint32 _remoteNodeId;


    Map<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UnnumberedAdjacencyBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link UnnumberedAdjacency}.
     *
     * @param base UnnumberedAdjacency from which the builder should be initialized
     */
    public UnnumberedAdjacencyBuilder(UnnumberedAdjacency base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._localInterfaceId = base.getLocalInterfaceId();
        this._localNodeId = base.getLocalNodeId();
        this._remoteInterfaceId = base.getRemoteInterfaceId();
        this._remoteNodeId = base.getRemoteNodeId();
    }



    /**
     * Return current value associated with the property corresponding to {@link UnnumberedAdjacency#getLocalInterfaceId()}.
     *
     * @return current value
     */
    public Uint32 getLocalInterfaceId() {
        return _localInterfaceId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnnumberedAdjacency#getLocalNodeId()}.
     *
     * @return current value
     */
    public Uint32 getLocalNodeId() {
        return _localNodeId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnnumberedAdjacency#getRemoteInterfaceId()}.
     *
     * @return current value
     */
    public Uint32 getRemoteInterfaceId() {
        return _remoteInterfaceId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link UnnumberedAdjacency#getRemoteNodeId()}.
     *
     * @return current value
     */
    public Uint32 getRemoteNodeId() {
        return _remoteNodeId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UnnumberedAdjacency>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link UnnumberedAdjacency#getLocalInterfaceId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedAdjacencyBuilder setLocalInterfaceId(final Uint32 value) {
        this._localInterfaceId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnnumberedAdjacency#getLocalNodeId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedAdjacencyBuilder setLocalNodeId(final Uint32 value) {
        this._localNodeId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnnumberedAdjacency#getRemoteInterfaceId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedAdjacencyBuilder setRemoteInterfaceId(final Uint32 value) {
        this._remoteInterfaceId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link UnnumberedAdjacency#getRemoteNodeId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedAdjacencyBuilder setRemoteNodeId(final Uint32 value) {
        this._remoteNodeId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UnnumberedAdjacencyBuilder addAugmentation(Augmentation<UnnumberedAdjacency> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UnnumberedAdjacencyBuilder removeAugmentation(Class<? extends Augmentation<UnnumberedAdjacency>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link UnnumberedAdjacency} instance.
     *
     * @return A new {@link UnnumberedAdjacency} instance.
     */
    public @NonNull UnnumberedAdjacency build() {
        return new UnnumberedAdjacencyImpl(this);
    }

    private static final class UnnumberedAdjacencyImpl
        extends AbstractAugmentable<UnnumberedAdjacency>
        implements UnnumberedAdjacency {
    
        private final Uint32 _localInterfaceId;
        private final Uint32 _localNodeId;
        private final Uint32 _remoteInterfaceId;
        private final Uint32 _remoteNodeId;
    
        UnnumberedAdjacencyImpl(UnnumberedAdjacencyBuilder base) {
            super(base.augmentation);
            this._localInterfaceId = base.getLocalInterfaceId();
            this._localNodeId = base.getLocalNodeId();
            this._remoteInterfaceId = base.getRemoteInterfaceId();
            this._remoteNodeId = base.getRemoteNodeId();
        }
    
        @Override
        public Uint32 getLocalInterfaceId() {
            return _localInterfaceId;
        }
        
        @Override
        public Uint32 getLocalNodeId() {
            return _localNodeId;
        }
        
        @Override
        public Uint32 getRemoteInterfaceId() {
            return _remoteInterfaceId;
        }
        
        @Override
        public Uint32 getRemoteNodeId() {
            return _remoteNodeId;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = UnnumberedAdjacency.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return UnnumberedAdjacency.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return UnnumberedAdjacency.bindingToString(this);
        }
    }
}
