/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.pcep.sr.cfg;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.pcep.sr.cfg.AbstractSrPCEPSessionProposalFactoryModule;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.segment.routing.SegmentRoutingSessionProposalFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrPCEPSessionProposalFactoryModule
extends AbstractSrPCEPSessionProposalFactoryModule {
    private static final String VALUE_IS_NOT_SET = "value is not set.";
    private static final int DEADTIMER_KEEPALIVE_RATIO = 4;
    private static final Logger LOG = LoggerFactory.getLogger(SrPCEPSessionProposalFactoryModule.class);

    public SrPCEPSessionProposalFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public SrPCEPSessionProposalFactoryModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, SrPCEPSessionProposalFactoryModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
        JmxAttributeValidationException.checkNotNull((Object)this.getActive(), (String)VALUE_IS_NOT_SET, (JmxAttribute)activeJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getInitiated(), (String)VALUE_IS_NOT_SET, (JmxAttribute)initiatedJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getDeadTimerValue(), (String)VALUE_IS_NOT_SET, (JmxAttribute)deadTimerValueJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getKeepAliveTimerValue(), (String)VALUE_IS_NOT_SET, (JmxAttribute)keepAliveTimerValueJmxAttribute);
        if (this.getKeepAliveTimerValue() != 0) {
            JmxAttributeValidationException.checkCondition((this.getKeepAliveTimerValue() >= 1 ? 1 : 0) != 0, (String)"minimum value is 1.", (JmxAttribute)keepAliveTimerValueJmxAttribute);
            if (this.getDeadTimerValue() != 0 && this.getDeadTimerValue() / this.getKeepAliveTimerValue() != 4) {
                LOG.warn("DeadTimerValue should be 4 times greater than KeepAliveTimerValue");
            }
        }
        if (this.getActive().booleanValue() && !this.getStateful().booleanValue()) {
            this.setStateful(true);
        }
        JmxAttributeValidationException.checkNotNull((Object)this.getStateful(), (String)VALUE_IS_NOT_SET, (JmxAttribute)statefulJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getSrCapable(), (String)VALUE_IS_NOT_SET, (JmxAttribute)srCapableJmxAttribute);
    }

    public AutoCloseable createInstance() {
        SegmentRoutingSessionProposalFactory inner = new SegmentRoutingSessionProposalFactory(this.getDeadTimerValue().shortValue(), this.getKeepAliveTimerValue().shortValue(), this.getStateful(), this.getActive(), this.getInitiated(), this.getSrCapable());
        return new PCEPSessionProposalFactoryCloseable(inner);
    }

    private static final class PCEPSessionProposalFactoryCloseable
    implements PCEPSessionProposalFactory,
    AutoCloseable {
        private final SegmentRoutingSessionProposalFactory inner;

        public PCEPSessionProposalFactoryCloseable(SegmentRoutingSessionProposalFactory inner) {
            this.inner = (SegmentRoutingSessionProposalFactory)((Object)Preconditions.checkNotNull((Object)((Object)inner)));
        }

        @Override
        public void close() {
        }

        public Open getSessionProposal(InetSocketAddress inetSocketAddress, int sessionId) {
            return this.inner.getSessionProposal(inetSocketAddress, sessionId);
        }
    }
}

