/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.segment.routing.AbstractSrSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.add.lsp.input.arguments.ero.subobject.subobject.type.SrEroTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.basic.explicit.route.subobjects.SubobjectType;

public class SrEroSubobjectParser
extends AbstractSrSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 5;

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof SrSubobject), (String)"Unknown subobject instance. Passed %s. Needed SrSubobject.", (Object[])new Object[]{subobject.getSubobjectType().getClass()});
        SrSubobject srSubobject = (SrSubobject)subobject.getSubobjectType();
        ByteBuf body = this.serializeSubobject(srSubobject);
        EROSubobjectUtil.formatSubobject((int)5, (Boolean)subobject.isLoose(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        SrEroTypeBuilder srEroSubobjectBuilder = new SrEroTypeBuilder(this.parseSrSubobject(buffer));
        SubobjectBuilder subobjectBuilder = new SubobjectBuilder();
        subobjectBuilder.setLoose(Boolean.valueOf(loose));
        subobjectBuilder.setSubobjectType((SubobjectType)srEroSubobjectBuilder.build());
        return subobjectBuilder.build();
    }
}

