/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.segment.routing.AbstractSrSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.add.lsp.input.arguments.rro.subobject.subobject.type.SrRroTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.record.route.subobjects.SubobjectType;

public class SrRroSubobjectParser
extends AbstractSrSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 6;

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof SrSubobject), (String)"Unknown subobject instance. Passed %s. Needed SrSubobject.", (Object[])new Object[]{subobject.getSubobjectType().getClass()});
        SrSubobject srSubobject = (SrSubobject)subobject.getSubobjectType();
        ByteBuf body = this.serializeSubobject(srSubobject);
        RROSubobjectUtil.formatSubobject((int)6, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        SrRroTypeBuilder srRroSubobjectBuilder = new SrRroTypeBuilder(this.parseSrSubobject(buffer));
        SubobjectBuilder subobjectBuilder = new SubobjectBuilder();
        subobjectBuilder.setSubobjectType((SubobjectType)srRroSubobjectBuilder.build());
        return subobjectBuilder.build();
    }
}

