/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sr.cfg.rev140609.modules.module.configuration;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sr.cfg.rev140609.modules.module.configuration.PcepSessionProposalFactorySr;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepSessionProposalFactorySrBuilder
implements Builder<PcepSessionProposalFactorySr> {
    private Short _deadTimerValue;
    private Short _keepAliveTimerValue;
    private Boolean _active;
    private Boolean _initiated;
    private Boolean _srCapable;
    private Boolean _stateful;
    Map<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>> augmentation = Collections.emptyMap();

    public PcepSessionProposalFactorySrBuilder() {
    }

    public PcepSessionProposalFactorySrBuilder(PcepSessionProposalFactorySr base) {
        AugmentationHolder casted;
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        this._active = base.isActive();
        this._initiated = base.isInitiated();
        this._srCapable = base.isSrCapable();
        this._stateful = base.isStateful();
        if (base instanceof PcepSessionProposalFactorySrImpl) {
            PcepSessionProposalFactorySrImpl impl = (PcepSessionProposalFactorySrImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>>(casted.augmentations());
        }
    }

    public Short getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Short getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public Boolean isActive() {
        return this._active;
    }

    public Boolean isInitiated() {
        return this._initiated;
    }

    public Boolean isSrCapable() {
        return this._srCapable;
    }

    public Boolean isStateful() {
        return this._stateful;
    }

    public <E extends Augmentation<PcepSessionProposalFactorySr>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeadTimerValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PcepSessionProposalFactorySrBuilder setDeadTimerValue(Short value) {
        if (value != null) {
            PcepSessionProposalFactorySrBuilder.checkDeadTimerValueRange(value);
        }
        this._deadTimerValue = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _deadTimerValue_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkKeepAliveTimerValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PcepSessionProposalFactorySrBuilder setKeepAliveTimerValue(Short value) {
        if (value != null) {
            PcepSessionProposalFactorySrBuilder.checkKeepAliveTimerValueRange(value);
        }
        this._keepAliveTimerValue = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _keepAliveTimerValue_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public PcepSessionProposalFactorySrBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public PcepSessionProposalFactorySrBuilder setInitiated(Boolean value) {
        this._initiated = value;
        return this;
    }

    public PcepSessionProposalFactorySrBuilder setSrCapable(Boolean value) {
        this._srCapable = value;
        return this;
    }

    public PcepSessionProposalFactorySrBuilder setStateful(Boolean value) {
        this._stateful = value;
        return this;
    }

    public PcepSessionProposalFactorySrBuilder addAugmentation(Class<? extends Augmentation<PcepSessionProposalFactorySr>> augmentationType, Augmentation<PcepSessionProposalFactorySr> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepSessionProposalFactorySrBuilder removeAugmentation(Class<? extends Augmentation<PcepSessionProposalFactorySr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcepSessionProposalFactorySr build() {
        return new PcepSessionProposalFactorySrImpl(this);
    }

    private static final class PcepSessionProposalFactorySrImpl
    implements PcepSessionProposalFactorySr {
        private final Short _deadTimerValue;
        private final Short _keepAliveTimerValue;
        private final Boolean _active;
        private final Boolean _initiated;
        private final Boolean _srCapable;
        private final Boolean _stateful;
        private Map<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcepSessionProposalFactorySr> getImplementedInterface() {
            return PcepSessionProposalFactorySr.class;
        }

        private PcepSessionProposalFactorySrImpl(PcepSessionProposalFactorySrBuilder base) {
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
            this._active = base.isActive();
            this._initiated = base.isInitiated();
            this._srCapable = base.isSrCapable();
            this._stateful = base.isStateful();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getDeadTimerValue() {
            return this._deadTimerValue;
        }

        @Override
        public Short getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        @Override
        public Boolean isActive() {
            return this._active;
        }

        @Override
        public Boolean isInitiated() {
            return this._initiated;
        }

        @Override
        public Boolean isSrCapable() {
            return this._srCapable;
        }

        @Override
        public Boolean isStateful() {
            return this._stateful;
        }

        public <E extends Augmentation<PcepSessionProposalFactorySr>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._deadTimerValue == null ? 0 : this._deadTimerValue.hashCode());
            result = 31 * result + (this._keepAliveTimerValue == null ? 0 : this._keepAliveTimerValue.hashCode());
            result = 31 * result + (this._active == null ? 0 : this._active.hashCode());
            result = 31 * result + (this._initiated == null ? 0 : this._initiated.hashCode());
            result = 31 * result + (this._srCapable == null ? 0 : this._srCapable.hashCode());
            result = 31 * result + (this._stateful == null ? 0 : this._stateful.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSessionProposalFactorySr.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepSessionProposalFactorySr other = (PcepSessionProposalFactorySr)obj;
            if (this._deadTimerValue == null ? other.getDeadTimerValue() != null : !this._deadTimerValue.equals(other.getDeadTimerValue())) {
                return false;
            }
            if (this._keepAliveTimerValue == null ? other.getKeepAliveTimerValue() != null : !this._keepAliveTimerValue.equals(other.getKeepAliveTimerValue())) {
                return false;
            }
            if (this._active == null ? other.isActive() != null : !this._active.equals(other.isActive())) {
                return false;
            }
            if (this._initiated == null ? other.isInitiated() != null : !this._initiated.equals(other.isInitiated())) {
                return false;
            }
            if (this._srCapable == null ? other.isSrCapable() != null : !this._srCapable.equals(other.isSrCapable())) {
                return false;
            }
            if (this._stateful == null ? other.isStateful() != null : !this._stateful.equals(other.isStateful())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSessionProposalFactorySrImpl otherImpl = (PcepSessionProposalFactorySrImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepSessionProposalFactorySr>>, Augmentation<PcepSessionProposalFactorySr>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcepSessionProposalFactorySr [");
            boolean first = true;
            if (this._deadTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadTimerValue=");
                builder.append(this._deadTimerValue);
            }
            if (this._keepAliveTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveTimerValue=");
                builder.append(this._keepAliveTimerValue);
            }
            if (this._active != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_active=");
                builder.append(this._active);
            }
            if (this._initiated != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_initiated=");
                builder.append(this._initiated);
            }
            if (this._srCapable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srCapable=");
                builder.append(this._srCapable);
            }
            if (this._stateful != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateful=");
                builder.append(this._stateful);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

