/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.pcrep.pcrep.message.replies.result.success._case.success.paths.ero.subobject.subobject.type;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SidType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.pcrep.pcrep.message.replies.result.success._case.success.paths.ero.subobject.subobject.type.SrEroType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.Nai;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrEroTypeBuilder
implements Builder<SrEroType> {
    private Nai _nai;
    private Long _sid;
    private SidType _sidType;
    private Boolean _cFlag;
    private Boolean _mFlag;
    Map<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>> augmentation = Collections.emptyMap();

    public SrEroTypeBuilder() {
    }

    public SrEroTypeBuilder(SrSubobject arg) {
        this._cFlag = arg.isCFlag();
        this._mFlag = arg.isMFlag();
        this._sidType = arg.getSidType();
        this._sid = arg.getSid();
        this._nai = arg.getNai();
    }

    public SrEroTypeBuilder(SrEroType base) {
        AugmentationHolder casted;
        this._nai = base.getNai();
        this._sid = base.getSid();
        this._sidType = base.getSidType();
        this._cFlag = base.isCFlag();
        this._mFlag = base.isMFlag();
        if (base instanceof SrEroTypeImpl) {
            SrEroTypeImpl impl = (SrEroTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrSubobject) {
            this._cFlag = ((SrSubobject)arg).isCFlag();
            this._mFlag = ((SrSubobject)arg).isMFlag();
            this._sidType = ((SrSubobject)arg).getSidType();
            this._sid = ((SrSubobject)arg).getSid();
            this._nai = ((SrSubobject)arg).getNai();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject] \nbut was: " + arg);
        }
    }

    public Nai getNai() {
        return this._nai;
    }

    public Long getSid() {
        return this._sid;
    }

    public SidType getSidType() {
        return this._sidType;
    }

    public Boolean isCFlag() {
        return this._cFlag;
    }

    public Boolean isMFlag() {
        return this._mFlag;
    }

    public <E extends Augmentation<SrEroType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SrEroTypeBuilder setNai(Nai value) {
        this._nai = value;
        return this;
    }

    private static void checkSidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SrEroTypeBuilder setSid(Long value) {
        if (value != null) {
            SrEroTypeBuilder.checkSidRange(value);
        }
        this._sid = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _sid_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    public SrEroTypeBuilder setSidType(SidType value) {
        this._sidType = value;
        return this;
    }

    public SrEroTypeBuilder setCFlag(Boolean value) {
        this._cFlag = value;
        return this;
    }

    public SrEroTypeBuilder setMFlag(Boolean value) {
        this._mFlag = value;
        return this;
    }

    public SrEroTypeBuilder addAugmentation(Class<? extends Augmentation<SrEroType>> augmentationType, Augmentation<SrEroType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SrEroTypeBuilder removeAugmentation(Class<? extends Augmentation<SrEroType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SrEroType build() {
        return new SrEroTypeImpl(this);
    }

    private static final class SrEroTypeImpl
    implements SrEroType {
        private final Nai _nai;
        private final Long _sid;
        private final SidType _sidType;
        private final Boolean _cFlag;
        private final Boolean _mFlag;
        private Map<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SrEroType> getImplementedInterface() {
            return SrEroType.class;
        }

        private SrEroTypeImpl(SrEroTypeBuilder base) {
            this._nai = base.getNai();
            this._sid = base.getSid();
            this._sidType = base.getSidType();
            this._cFlag = base.isCFlag();
            this._mFlag = base.isMFlag();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>>(base.augmentation);
                }
            }
        }

        @Override
        public Nai getNai() {
            return this._nai;
        }

        @Override
        public Long getSid() {
            return this._sid;
        }

        @Override
        public SidType getSidType() {
            return this._sidType;
        }

        @Override
        public Boolean isCFlag() {
            return this._cFlag;
        }

        @Override
        public Boolean isMFlag() {
            return this._mFlag;
        }

        public <E extends Augmentation<SrEroType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nai == null ? 0 : this._nai.hashCode());
            result = 31 * result + (this._sid == null ? 0 : this._sid.hashCode());
            result = 31 * result + (this._sidType == null ? 0 : this._sidType.hashCode());
            result = 31 * result + (this._cFlag == null ? 0 : this._cFlag.hashCode());
            result = 31 * result + (this._mFlag == null ? 0 : this._mFlag.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrEroType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrEroType other = (SrEroType)obj;
            if (this._nai == null ? other.getNai() != null : !this._nai.equals(other.getNai())) {
                return false;
            }
            if (this._sid == null ? other.getSid() != null : !this._sid.equals(other.getSid())) {
                return false;
            }
            if (this._sidType == null ? other.getSidType() != null : !this._sidType.equals((Object)other.getSidType())) {
                return false;
            }
            if (this._cFlag == null ? other.isCFlag() != null : !this._cFlag.equals(other.isCFlag())) {
                return false;
            }
            if (this._mFlag == null ? other.isMFlag() != null : !this._mFlag.equals(other.isMFlag())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrEroTypeImpl otherImpl = (SrEroTypeImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SrEroType>>, Augmentation<SrEroType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SrEroType [");
            boolean first = true;
            if (this._nai != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nai=");
                builder.append(this._nai);
            }
            if (this._sid != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sid=");
                builder.append(this._sid);
            }
            if (this._sidType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sidType=");
                builder.append((Object)this._sidType);
            }
            if (this._cFlag != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_cFlag=");
                builder.append(this._cFlag);
            }
            if (this._mFlag != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mFlag=");
                builder.append(this._mFlag);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

