/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.pce.capability.tlv;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.pce.capability.tlv.SrPceCapability;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrPceCapabilityBuilder
implements Builder<SrPceCapability> {
    private Short _msd;
    Map<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>> augmentation = Collections.emptyMap();

    public SrPceCapabilityBuilder() {
    }

    public SrPceCapabilityBuilder(SrPceCapability base) {
        AugmentationHolder casted;
        this._msd = base.getMsd();
        if (base instanceof SrPceCapabilityImpl) {
            SrPceCapabilityImpl impl = (SrPceCapabilityImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>>(casted.augmentations());
        }
    }

    public Short getMsd() {
        return this._msd;
    }

    public <E extends Augmentation<SrPceCapability>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMsdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public SrPceCapabilityBuilder setMsd(Short value) {
        if (value != null) {
            SrPceCapabilityBuilder.checkMsdRange(value);
        }
        this._msd = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _msd_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public SrPceCapabilityBuilder addAugmentation(Class<? extends Augmentation<SrPceCapability>> augmentationType, Augmentation<SrPceCapability> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SrPceCapabilityBuilder removeAugmentation(Class<? extends Augmentation<SrPceCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SrPceCapability build() {
        return new SrPceCapabilityImpl(this);
    }

    private static final class SrPceCapabilityImpl
    implements SrPceCapability {
        private final Short _msd;
        private Map<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SrPceCapability> getImplementedInterface() {
            return SrPceCapability.class;
        }

        private SrPceCapabilityImpl(SrPceCapabilityBuilder base) {
            this._msd = base.getMsd();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getMsd() {
            return this._msd;
        }

        public <E extends Augmentation<SrPceCapability>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._msd == null ? 0 : this._msd.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrPceCapability.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrPceCapability other = (SrPceCapability)obj;
            if (this._msd == null ? other.getMsd() != null : !this._msd.equals(other.getMsd())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrPceCapabilityImpl otherImpl = (SrPceCapabilityImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SrPceCapability>>, Augmentation<SrPceCapability>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SrPceCapability [");
            boolean first = true;
            if (this._msd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_msd=");
                builder.append(this._msd);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

