/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.segment.routing.AbstractSrSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.add.lsp.input.arguments.rro.subobject.subobject.type.SrRroTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType;

public class SrRroSubobjectParser
extends AbstractSrSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    private static final int LEGACY_TYPE = 6;
    private static final int PROPOSED_TYPE = 36;
    private final int type;

    SrRroSubobjectParser(boolean isIanaAssignedType) {
        this.type = isIanaAssignedType ? 36 : 6;
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof SrSubobject), (String)"Unknown subobject instance. Passed %s. Needed SrSubobject.", (Object[])new Object[]{subobject.getSubobjectType().getClass()});
        SrSubobject srSubobject = (SrSubobject)subobject.getSubobjectType();
        ByteBuf body = this.serializeSubobject(srSubobject);
        RROSubobjectUtil.formatSubobject((int)this.type, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        SrRroTypeBuilder srRroSubobjectBuilder = new SrRroTypeBuilder(SrRroSubobjectParser.parseSrSubobject(buffer));
        SubobjectBuilder subobjectBuilder = new SubobjectBuilder();
        subobjectBuilder.setSubobjectType((SubobjectType)srRroSubobjectBuilder.build());
        return subobjectBuilder.build();
    }

    public int getCodePoint() {
        return this.type;
    }
}

