/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sr.cfg.rev140609.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sr.cfg.rev140609.modules.module.configuration.PcepSegmentRoutingCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful07.cfg.rev150714.StatefulCapabilities;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepSegmentRoutingCapabilityBuilder
implements Builder<PcepSegmentRoutingCapability> {
    private Short _deadTimerValue;
    private Short _keepAliveTimerValue;
    private Boolean _active;
    private Boolean _deltaLspSyncCapability;
    private Boolean _includeDbVersion;
    private Boolean _initiated;
    private Boolean _srCapable;
    private Boolean _stateful;
    private Boolean _triggeredInitialSync;
    private Boolean _triggeredResync;
    Map<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>> augmentation = Collections.emptyMap();

    public PcepSegmentRoutingCapabilityBuilder() {
    }

    public PcepSegmentRoutingCapabilityBuilder(StatefulCapabilities arg) {
        this._deadTimerValue = arg.getDeadTimerValue();
        this._keepAliveTimerValue = arg.getKeepAliveTimerValue();
        this._initiated = arg.isInitiated();
        this._stateful = arg.isStateful();
        this._active = arg.isActive();
        this._triggeredInitialSync = arg.isTriggeredInitialSync();
        this._deltaLspSyncCapability = arg.isDeltaLspSyncCapability();
        this._triggeredResync = arg.isTriggeredResync();
        this._includeDbVersion = arg.isIncludeDbVersion();
    }

    public PcepSegmentRoutingCapabilityBuilder(PcepSegmentRoutingCapability base) {
        AugmentationHolder casted;
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        this._active = base.isActive();
        this._deltaLspSyncCapability = base.isDeltaLspSyncCapability();
        this._includeDbVersion = base.isIncludeDbVersion();
        this._initiated = base.isInitiated();
        this._srCapable = base.isSrCapable();
        this._stateful = base.isStateful();
        this._triggeredInitialSync = base.isTriggeredInitialSync();
        this._triggeredResync = base.isTriggeredResync();
        if (base instanceof PcepSegmentRoutingCapabilityImpl) {
            PcepSegmentRoutingCapabilityImpl impl = (PcepSegmentRoutingCapabilityImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatefulCapabilities) {
            this._deadTimerValue = ((StatefulCapabilities)arg).getDeadTimerValue();
            this._keepAliveTimerValue = ((StatefulCapabilities)arg).getKeepAliveTimerValue();
            this._initiated = ((StatefulCapabilities)arg).isInitiated();
            this._stateful = ((StatefulCapabilities)arg).isStateful();
            this._active = ((StatefulCapabilities)arg).isActive();
            this._triggeredInitialSync = ((StatefulCapabilities)arg).isTriggeredInitialSync();
            this._deltaLspSyncCapability = ((StatefulCapabilities)arg).isDeltaLspSyncCapability();
            this._triggeredResync = ((StatefulCapabilities)arg).isTriggeredResync();
            this._includeDbVersion = ((StatefulCapabilities)arg).isIncludeDbVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful07.cfg.rev150714.StatefulCapabilities] \nbut was: " + arg);
        }
    }

    public Short getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Short getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public Boolean isActive() {
        return this._active;
    }

    public Boolean isDeltaLspSyncCapability() {
        return this._deltaLspSyncCapability;
    }

    public Boolean isIncludeDbVersion() {
        return this._includeDbVersion;
    }

    public Boolean isInitiated() {
        return this._initiated;
    }

    public Boolean isSrCapable() {
        return this._srCapable;
    }

    public Boolean isStateful() {
        return this._stateful;
    }

    public Boolean isTriggeredInitialSync() {
        return this._triggeredInitialSync;
    }

    public Boolean isTriggeredResync() {
        return this._triggeredResync;
    }

    public <E extends Augmentation<PcepSegmentRoutingCapability>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeadTimerValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PcepSegmentRoutingCapabilityBuilder setDeadTimerValue(Short value) {
        if (value != null) {
            PcepSegmentRoutingCapabilityBuilder.checkDeadTimerValueRange(value);
        }
        this._deadTimerValue = value;
        return this;
    }

    private static void checkKeepAliveTimerValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public PcepSegmentRoutingCapabilityBuilder setKeepAliveTimerValue(Short value) {
        if (value != null) {
            PcepSegmentRoutingCapabilityBuilder.checkKeepAliveTimerValueRange(value);
        }
        this._keepAliveTimerValue = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setDeltaLspSyncCapability(Boolean value) {
        this._deltaLspSyncCapability = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setIncludeDbVersion(Boolean value) {
        this._includeDbVersion = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setInitiated(Boolean value) {
        this._initiated = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setSrCapable(Boolean value) {
        this._srCapable = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setStateful(Boolean value) {
        this._stateful = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setTriggeredInitialSync(Boolean value) {
        this._triggeredInitialSync = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder setTriggeredResync(Boolean value) {
        this._triggeredResync = value;
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder addAugmentation(Class<? extends Augmentation<PcepSegmentRoutingCapability>> augmentationType, Augmentation<PcepSegmentRoutingCapability> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepSegmentRoutingCapabilityBuilder removeAugmentation(Class<? extends Augmentation<PcepSegmentRoutingCapability>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcepSegmentRoutingCapability build() {
        return new PcepSegmentRoutingCapabilityImpl(this);
    }

    private static final class PcepSegmentRoutingCapabilityImpl
    implements PcepSegmentRoutingCapability {
        private final Short _deadTimerValue;
        private final Short _keepAliveTimerValue;
        private final Boolean _active;
        private final Boolean _deltaLspSyncCapability;
        private final Boolean _includeDbVersion;
        private final Boolean _initiated;
        private final Boolean _srCapable;
        private final Boolean _stateful;
        private final Boolean _triggeredInitialSync;
        private final Boolean _triggeredResync;
        private Map<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcepSegmentRoutingCapability> getImplementedInterface() {
            return PcepSegmentRoutingCapability.class;
        }

        private PcepSegmentRoutingCapabilityImpl(PcepSegmentRoutingCapabilityBuilder base) {
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
            this._active = base.isActive();
            this._deltaLspSyncCapability = base.isDeltaLspSyncCapability();
            this._includeDbVersion = base.isIncludeDbVersion();
            this._initiated = base.isInitiated();
            this._srCapable = base.isSrCapable();
            this._stateful = base.isStateful();
            this._triggeredInitialSync = base.isTriggeredInitialSync();
            this._triggeredResync = base.isTriggeredResync();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>>(base.augmentation);
                }
            }
        }

        public Short getDeadTimerValue() {
            return this._deadTimerValue;
        }

        public Short getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        public Boolean isActive() {
            return this._active;
        }

        public Boolean isDeltaLspSyncCapability() {
            return this._deltaLspSyncCapability;
        }

        public Boolean isIncludeDbVersion() {
            return this._includeDbVersion;
        }

        public Boolean isInitiated() {
            return this._initiated;
        }

        @Override
        public Boolean isSrCapable() {
            return this._srCapable;
        }

        public Boolean isStateful() {
            return this._stateful;
        }

        public Boolean isTriggeredInitialSync() {
            return this._triggeredInitialSync;
        }

        public Boolean isTriggeredResync() {
            return this._triggeredResync;
        }

        public <E extends Augmentation<PcepSegmentRoutingCapability>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadTimerValue);
            result = 31 * result + Objects.hashCode(this._keepAliveTimerValue);
            result = 31 * result + Objects.hashCode(this._active);
            result = 31 * result + Objects.hashCode(this._deltaLspSyncCapability);
            result = 31 * result + Objects.hashCode(this._includeDbVersion);
            result = 31 * result + Objects.hashCode(this._initiated);
            result = 31 * result + Objects.hashCode(this._srCapable);
            result = 31 * result + Objects.hashCode(this._stateful);
            result = 31 * result + Objects.hashCode(this._triggeredInitialSync);
            result = 31 * result + Objects.hashCode(this._triggeredResync);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSegmentRoutingCapability.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepSegmentRoutingCapability other = (PcepSegmentRoutingCapability)obj;
            if (!Objects.equals(this._deadTimerValue, other.getDeadTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._keepAliveTimerValue, other.getKeepAliveTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._active, other.isActive())) {
                return false;
            }
            if (!Objects.equals(this._deltaLspSyncCapability, other.isDeltaLspSyncCapability())) {
                return false;
            }
            if (!Objects.equals(this._includeDbVersion, other.isIncludeDbVersion())) {
                return false;
            }
            if (!Objects.equals(this._initiated, other.isInitiated())) {
                return false;
            }
            if (!Objects.equals(this._srCapable, other.isSrCapable())) {
                return false;
            }
            if (!Objects.equals(this._stateful, other.isStateful())) {
                return false;
            }
            if (!Objects.equals(this._triggeredInitialSync, other.isTriggeredInitialSync())) {
                return false;
            }
            if (!Objects.equals(this._triggeredResync, other.isTriggeredResync())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSegmentRoutingCapabilityImpl otherImpl = (PcepSegmentRoutingCapabilityImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepSegmentRoutingCapability>>, Augmentation<PcepSegmentRoutingCapability>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcepSegmentRoutingCapability [");
            boolean first = true;
            if (this._deadTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadTimerValue=");
                builder.append(this._deadTimerValue);
            }
            if (this._keepAliveTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveTimerValue=");
                builder.append(this._keepAliveTimerValue);
            }
            if (this._active != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_active=");
                builder.append(this._active);
            }
            if (this._deltaLspSyncCapability != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deltaLspSyncCapability=");
                builder.append(this._deltaLspSyncCapability);
            }
            if (this._includeDbVersion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeDbVersion=");
                builder.append(this._includeDbVersion);
            }
            if (this._initiated != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_initiated=");
                builder.append(this._initiated);
            }
            if (this._srCapable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srCapable=");
                builder.append(this._srCapable);
            }
            if (this._stateful != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateful=");
                builder.append(this._stateful);
            }
            if (this._triggeredInitialSync != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_triggeredInitialSync=");
                builder.append(this._triggeredInitialSync);
            }
            if (this._triggeredResync != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_triggeredResync=");
                builder.append(this._triggeredResync);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

