/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpAdjacency;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpAdjacencyBuilder
implements Builder<IpAdjacency> {
    private IpAddress _localIpAddress;
    private IpAddress _remoteIpAddress;
    Map<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>> augmentation = Collections.emptyMap();

    public IpAdjacencyBuilder() {
    }

    public IpAdjacencyBuilder(IpAdjacency base) {
        AugmentationHolder casted;
        this._localIpAddress = base.getLocalIpAddress();
        this._remoteIpAddress = base.getRemoteIpAddress();
        if (base instanceof IpAdjacencyImpl) {
            IpAdjacencyImpl impl = (IpAdjacencyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>>(casted.augmentations());
        }
    }

    public IpAddress getLocalIpAddress() {
        return this._localIpAddress;
    }

    public IpAddress getRemoteIpAddress() {
        return this._remoteIpAddress;
    }

    public <E extends Augmentation<IpAdjacency>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IpAdjacencyBuilder setLocalIpAddress(IpAddress value) {
        this._localIpAddress = value;
        return this;
    }

    public IpAdjacencyBuilder setRemoteIpAddress(IpAddress value) {
        this._remoteIpAddress = value;
        return this;
    }

    public IpAdjacencyBuilder addAugmentation(Class<? extends Augmentation<IpAdjacency>> augmentationType, Augmentation<IpAdjacency> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpAdjacencyBuilder removeAugmentation(Class<? extends Augmentation<IpAdjacency>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IpAdjacency build() {
        return new IpAdjacencyImpl(this);
    }

    private static final class IpAdjacencyImpl
    implements IpAdjacency {
        private final IpAddress _localIpAddress;
        private final IpAddress _remoteIpAddress;
        private Map<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IpAdjacency> getImplementedInterface() {
            return IpAdjacency.class;
        }

        private IpAdjacencyImpl(IpAdjacencyBuilder base) {
            this._localIpAddress = base.getLocalIpAddress();
            this._remoteIpAddress = base.getRemoteIpAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getLocalIpAddress() {
            return this._localIpAddress;
        }

        @Override
        public IpAddress getRemoteIpAddress() {
            return this._remoteIpAddress;
        }

        public <E extends Augmentation<IpAdjacency>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._localIpAddress);
            result = 31 * result + Objects.hashCode(this._remoteIpAddress);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IpAdjacency.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IpAdjacency other = (IpAdjacency)obj;
            if (!Objects.equals(this._localIpAddress, other.getLocalIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._remoteIpAddress, other.getRemoteIpAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpAdjacencyImpl otherImpl = (IpAdjacencyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IpAdjacency>>, Augmentation<IpAdjacency>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IpAdjacency [");
            boolean first = true;
            if (this._localIpAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localIpAddress=");
                builder.append(this._localIpAddress);
            }
            if (this._remoteIpAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_remoteIpAddress=");
                builder.append(this._remoteIpAddress);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

