/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpNodeId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpNodeIdBuilder
implements Builder<IpNodeId> {
    private IpAddress _ipAddress;
    Map<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>> augmentation = Collections.emptyMap();

    public IpNodeIdBuilder() {
    }

    public IpNodeIdBuilder(IpNodeId base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        if (base instanceof IpNodeIdImpl) {
            IpNodeIdImpl impl = (IpNodeIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>>(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public <E extends Augmentation<IpNodeId>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IpNodeIdBuilder setIpAddress(IpAddress value) {
        this._ipAddress = value;
        return this;
    }

    public IpNodeIdBuilder addAugmentation(Class<? extends Augmentation<IpNodeId>> augmentationType, Augmentation<IpNodeId> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpNodeIdBuilder removeAugmentation(Class<? extends Augmentation<IpNodeId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IpNodeId build() {
        return new IpNodeIdImpl(this);
    }

    private static final class IpNodeIdImpl
    implements IpNodeId {
        private final IpAddress _ipAddress;
        private Map<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IpNodeId> getImplementedInterface() {
            return IpNodeId.class;
        }

        private IpNodeIdImpl(IpNodeIdBuilder base) {
            this._ipAddress = base.getIpAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        public <E extends Augmentation<IpNodeId>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipAddress);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IpNodeId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IpNodeId other = (IpNodeId)obj;
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpNodeIdImpl otherImpl = (IpNodeIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IpNodeId>>, Augmentation<IpNodeId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IpNodeId [");
            boolean first = true;
            if (this._ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

