/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SidType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.Nai;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpAdjacency;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpAdjacencyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpNodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.IpNodeIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.UnnumberedAdjacency;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.UnnumberedAdjacencyBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public abstract class AbstractSrSubobjectParser {
    protected static final int MINIMAL_LENGTH = 4;
    protected static final int BITSET_LENGTH = 8;
    protected static final int M_FLAG_POSITION = 7;
    protected static final int C_FLAG_POSITION = 6;
    protected static final int S_FLAG_POSITION = 5;
    protected static final int F_FLAG_POSITION = 4;
    protected static final int MPLS_LABEL_OFFSET = 12;
    private static final int SID_TYPE_BITS_OFFSET = 4;

    public ByteBuf serializeSubobject(SrSubobject srSubobject) {
        Nai nai;
        ByteBuf buffer = Unpooled.buffer((int)4);
        ByteBufWriteUtil.writeUnsignedByte((Short)((short)(srSubobject.getSidType().getIntValue() << 4)), (ByteBuf)buffer);
        BitArray bits = new BitArray(8);
        bits.set(7, srSubobject.isMFlag());
        bits.set(6, srSubobject.isCFlag());
        if (srSubobject.getSid() == null) {
            bits.set(5, Boolean.TRUE);
        }
        if (srSubobject.getNai() == null) {
            bits.set(4, Boolean.TRUE);
        }
        bits.toByteBuf(buffer);
        Preconditions.checkArgument((srSubobject.getNai() != null || srSubobject.getSid() != null ? 1 : 0) != 0, (Object)"Both SID and NAI are absent in SR subobject.");
        if (srSubobject.getSid() != null) {
            if (srSubobject.isMFlag().booleanValue()) {
                ByteBufWriteUtil.writeUnsignedInt((Long)(srSubobject.getSid() << 12), (ByteBuf)buffer);
            } else {
                ByteBufWriteUtil.writeUnsignedInt((Long)srSubobject.getSid(), (ByteBuf)buffer);
            }
        }
        if ((nai = srSubobject.getNai()) != null) {
            AbstractSrSubobjectParser.serializeNai(nai, srSubobject.getSidType(), buffer);
        }
        return buffer;
    }

    private static void serializeNai(Nai nai, SidType sidType, ByteBuf buffer) {
        switch (sidType) {
            case Ipv4NodeId: {
                ByteBufWriteUtil.writeIpv4Address((Ipv4Address)((IpNodeId)nai).getIpAddress().getIpv4Address(), (ByteBuf)buffer);
                break;
            }
            case Ipv6NodeId: {
                ByteBufWriteUtil.writeIpv6Address((Ipv6Address)((IpNodeId)nai).getIpAddress().getIpv6Address(), (ByteBuf)buffer);
                break;
            }
            case Ipv4Adjacency: {
                ByteBufWriteUtil.writeIpv4Address((Ipv4Address)((IpAdjacency)nai).getLocalIpAddress().getIpv4Address(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeIpv4Address((Ipv4Address)((IpAdjacency)nai).getRemoteIpAddress().getIpv4Address(), (ByteBuf)buffer);
                break;
            }
            case Ipv6Adjacency: {
                ByteBufWriteUtil.writeIpv6Address((Ipv6Address)((IpAdjacency)nai).getLocalIpAddress().getIpv6Address(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeIpv6Address((Ipv6Address)((IpAdjacency)nai).getRemoteIpAddress().getIpv6Address(), (ByteBuf)buffer);
                break;
            }
            case Unnumbered: {
                UnnumberedAdjacency unnumbered = (UnnumberedAdjacency)nai;
                ByteBufWriteUtil.writeUnsignedInt((Long)unnumbered.getLocalNodeId(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeUnsignedInt((Long)unnumbered.getLocalInterfaceId(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeUnsignedInt((Long)unnumbered.getRemoteNodeId(), (ByteBuf)buffer);
                ByteBufWriteUtil.writeUnsignedInt((Long)unnumbered.getRemoteInterfaceId(), (ByteBuf)buffer);
                break;
            }
        }
    }

    private static Nai parseNai(SidType sidType, ByteBuf buffer) {
        switch (sidType) {
            case Ipv4NodeId: {
                return new IpNodeIdBuilder().setIpAddress(new IpAddress(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv6NodeId: {
                return new IpNodeIdBuilder().setIpAddress(new IpAddress(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv4Adjacency: {
                return new IpAdjacencyBuilder().setLocalIpAddress(new IpAddress(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).setRemoteIpAddress(new IpAddress(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv6Adjacency: {
                return new IpAdjacencyBuilder().setLocalIpAddress(new IpAddress(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).setRemoteIpAddress(new IpAddress(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Unnumbered: {
                return new UnnumberedAdjacencyBuilder().setLocalNodeId(buffer.readUnsignedInt()).setLocalInterfaceId(buffer.readUnsignedInt()).setRemoteNodeId(buffer.readUnsignedInt()).setRemoteInterfaceId(buffer.readUnsignedInt()).build();
            }
        }
        return null;
    }

    protected static SrSubobject parseSrSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        int sidTypeByte = buffer.readByte() >> 4;
        SidType sidType = SidType.forValue(sidTypeByte);
        BitArray bitSet = BitArray.valueOf((byte)buffer.readByte());
        boolean f = bitSet.get(4);
        boolean s = bitSet.get(5);
        boolean c = bitSet.get(6);
        boolean m = bitSet.get(7);
        if (f && s) {
            throw new PCEPDeserializerException("Both SID and NAI are absent in SR subobject.");
        }
        Long tmp = null;
        if (!s) {
            tmp = m ? Long.valueOf(buffer.readUnsignedInt() >>> 12) : Long.valueOf(buffer.readUnsignedInt());
        }
        Long sid = tmp;
        Nai nai = sidType != null && !f ? AbstractSrSubobjectParser.parseNai(sidType, buffer) : null;
        return new SrSubobjectImpl(m, c, sidType, sid, nai);
    }

    private static class SrSubobjectImpl
    implements SrSubobject {
        private final boolean m;
        private final boolean c;
        private final SidType sidType;
        private final Long sid;
        private final Nai nai;

        public SrSubobjectImpl(boolean m, boolean c, SidType sidType, Long sid, Nai nai) {
            this.m = m;
            this.c = c;
            this.sidType = sidType;
            this.sid = sid;
            this.nai = nai;
        }

        public Class<? extends DataContainer> getImplementedInterface() {
            return SrSubobject.class;
        }

        @Override
        public Boolean isMFlag() {
            return this.m;
        }

        @Override
        public Boolean isCFlag() {
            return this.c;
        }

        @Override
        public SidType getSidType() {
            return this.sidType;
        }

        @Override
        public Long getSid() {
            return this.sid;
        }

        @Override
        public Nai getNai() {
            return this.nai;
        }
    }
}

