/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.pce.capability.tlv.SrPceCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.pce.capability.tlv.SrPceCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

public class SrPceCapabilityTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 26;
    private static final int MSD_LENGTH = 1;
    private static final int CONTENT_LENGTH = 4;
    private static final int OFFSET = 3;

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof SrPceCapability), (Object)"SrPceCapability is mandatory.");
        ByteBuf body = Unpooled.buffer((int)4);
        body.writerIndex(3);
        ByteBufWriteUtil.writeUnsignedByte((Short)((SrPceCapability)tlv).getMsd(), (ByteBuf)body);
        TlvUtil.formatTlv((int)26, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        short msd = buffer.readerIndex(3).readUnsignedByte();
        return new SrPceCapabilityBuilder().setMsd(msd).build();
    }
}

