/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev150112.sr.subobject.nai.UnnumberedAdjacency;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UnnumberedAdjacencyBuilder
implements Builder<UnnumberedAdjacency> {
    private Long _localInterfaceId;
    private Long _localNodeId;
    private Long _remoteInterfaceId;
    private Long _remoteNodeId;
    Map<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>> augmentation = Collections.emptyMap();

    public UnnumberedAdjacencyBuilder() {
    }

    public UnnumberedAdjacencyBuilder(UnnumberedAdjacency base) {
        AugmentationHolder casted;
        this._localInterfaceId = base.getLocalInterfaceId();
        this._localNodeId = base.getLocalNodeId();
        this._remoteInterfaceId = base.getRemoteInterfaceId();
        this._remoteNodeId = base.getRemoteNodeId();
        if (base instanceof UnnumberedAdjacencyImpl) {
            UnnumberedAdjacencyImpl impl = (UnnumberedAdjacencyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>>(casted.augmentations());
        }
    }

    public Long getLocalInterfaceId() {
        return this._localInterfaceId;
    }

    public Long getLocalNodeId() {
        return this._localNodeId;
    }

    public Long getRemoteInterfaceId() {
        return this._remoteInterfaceId;
    }

    public Long getRemoteNodeId() {
        return this._remoteNodeId;
    }

    public <E extends Augmentation<UnnumberedAdjacency>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkLocalInterfaceIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UnnumberedAdjacencyBuilder setLocalInterfaceId(Long value) {
        if (value != null) {
            UnnumberedAdjacencyBuilder.checkLocalInterfaceIdRange(value);
        }
        this._localInterfaceId = value;
        return this;
    }

    private static void checkLocalNodeIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UnnumberedAdjacencyBuilder setLocalNodeId(Long value) {
        if (value != null) {
            UnnumberedAdjacencyBuilder.checkLocalNodeIdRange(value);
        }
        this._localNodeId = value;
        return this;
    }

    private static void checkRemoteInterfaceIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UnnumberedAdjacencyBuilder setRemoteInterfaceId(Long value) {
        if (value != null) {
            UnnumberedAdjacencyBuilder.checkRemoteInterfaceIdRange(value);
        }
        this._remoteInterfaceId = value;
        return this;
    }

    private static void checkRemoteNodeIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public UnnumberedAdjacencyBuilder setRemoteNodeId(Long value) {
        if (value != null) {
            UnnumberedAdjacencyBuilder.checkRemoteNodeIdRange(value);
        }
        this._remoteNodeId = value;
        return this;
    }

    public UnnumberedAdjacencyBuilder addAugmentation(Class<? extends Augmentation<UnnumberedAdjacency>> augmentationType, Augmentation<UnnumberedAdjacency> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UnnumberedAdjacencyBuilder removeAugmentation(Class<? extends Augmentation<UnnumberedAdjacency>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UnnumberedAdjacency build() {
        return new UnnumberedAdjacencyImpl(this);
    }

    private static final class UnnumberedAdjacencyImpl
    implements UnnumberedAdjacency {
        private final Long _localInterfaceId;
        private final Long _localNodeId;
        private final Long _remoteInterfaceId;
        private final Long _remoteNodeId;
        private Map<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UnnumberedAdjacency> getImplementedInterface() {
            return UnnumberedAdjacency.class;
        }

        private UnnumberedAdjacencyImpl(UnnumberedAdjacencyBuilder base) {
            this._localInterfaceId = base.getLocalInterfaceId();
            this._localNodeId = base.getLocalNodeId();
            this._remoteInterfaceId = base.getRemoteInterfaceId();
            this._remoteNodeId = base.getRemoteNodeId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getLocalInterfaceId() {
            return this._localInterfaceId;
        }

        @Override
        public Long getLocalNodeId() {
            return this._localNodeId;
        }

        @Override
        public Long getRemoteInterfaceId() {
            return this._remoteInterfaceId;
        }

        @Override
        public Long getRemoteNodeId() {
            return this._remoteNodeId;
        }

        public <E extends Augmentation<UnnumberedAdjacency>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._localInterfaceId);
            result = 31 * result + Objects.hashCode(this._localNodeId);
            result = 31 * result + Objects.hashCode(this._remoteInterfaceId);
            result = 31 * result + Objects.hashCode(this._remoteNodeId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UnnumberedAdjacency.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UnnumberedAdjacency other = (UnnumberedAdjacency)obj;
            if (!Objects.equals(this._localInterfaceId, other.getLocalInterfaceId())) {
                return false;
            }
            if (!Objects.equals(this._localNodeId, other.getLocalNodeId())) {
                return false;
            }
            if (!Objects.equals(this._remoteInterfaceId, other.getRemoteInterfaceId())) {
                return false;
            }
            if (!Objects.equals(this._remoteNodeId, other.getRemoteNodeId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UnnumberedAdjacencyImpl otherImpl = (UnnumberedAdjacencyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UnnumberedAdjacency>>, Augmentation<UnnumberedAdjacency>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UnnumberedAdjacency [";
            StringBuilder builder = new StringBuilder(name);
            if (this._localInterfaceId != null) {
                builder.append("_localInterfaceId=");
                builder.append(this._localInterfaceId);
                builder.append(", ");
            }
            if (this._localNodeId != null) {
                builder.append("_localNodeId=");
                builder.append(this._localNodeId);
                builder.append(", ");
            }
            if (this._remoteInterfaceId != null) {
                builder.append("_remoteInterfaceId=");
                builder.append(this._remoteInterfaceId);
                builder.append(", ");
            }
            if (this._remoteNodeId != null) {
                builder.append("_remoteNodeId=");
                builder.append(this._remoteNodeId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

