/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.PathStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ConfiguredLspBuilder {
    private ComputedPath _computedPath;
    private IntendedPath _intendedPath;
    private String _name;
    private PathStatus _pathStatus;
    private ConfiguredLspKey key;
    Map<Class<? extends Augmentation<ConfiguredLsp>>, Augmentation<ConfiguredLsp>> augmentation = Map.of();

    public ConfiguredLspBuilder() {
    }

    public ConfiguredLspBuilder(ConfiguredLsp base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConfiguredLsp>>, Augmentation<ConfiguredLsp>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._computedPath = base.getComputedPath();
        this._intendedPath = base.getIntendedPath();
        this._pathStatus = base.getPathStatus();
    }

    public ConfiguredLspKey key() {
        return this.key;
    }

    public ComputedPath getComputedPath() {
        return this._computedPath;
    }

    public IntendedPath getIntendedPath() {
        return this._intendedPath;
    }

    public String getName() {
        return this._name;
    }

    public PathStatus getPathStatus() {
        return this._pathStatus;
    }

    public <E$$ extends Augmentation<ConfiguredLsp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfiguredLspBuilder withKey(ConfiguredLspKey key) {
        this.key = key;
        return this;
    }

    public ConfiguredLspBuilder setComputedPath(ComputedPath value) {
        this._computedPath = value;
        return this;
    }

    public ConfiguredLspBuilder setIntendedPath(IntendedPath value) {
        this._intendedPath = value;
        return this;
    }

    public ConfiguredLspBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ConfiguredLspBuilder setPathStatus(PathStatus value) {
        this._pathStatus = value;
        return this;
    }

    public ConfiguredLspBuilder addAugmentation(Augmentation<ConfiguredLsp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConfiguredLsp>>, Augmentation<ConfiguredLsp>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfiguredLspBuilder removeAugmentation(Class<? extends Augmentation<ConfiguredLsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ConfiguredLsp build() {
        return new ConfiguredLspImpl(this);
    }

    private static final class ConfiguredLspImpl
    extends AbstractAugmentable<ConfiguredLsp>
    implements ConfiguredLsp {
        private final ComputedPath _computedPath;
        private final IntendedPath _intendedPath;
        private final String _name;
        private final PathStatus _pathStatus;
        private final ConfiguredLspKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfiguredLspImpl(ConfiguredLspBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ConfiguredLspKey(base.getName());
            this._name = this.key.getName();
            this._computedPath = base.getComputedPath();
            this._intendedPath = base.getIntendedPath();
            this._pathStatus = base.getPathStatus();
        }

        @Override
        public ConfiguredLspKey key() {
            return this.key;
        }

        @Override
        public ComputedPath getComputedPath() {
            return this._computedPath;
        }

        @Override
        public IntendedPath getIntendedPath() {
            return this._intendedPath;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public PathStatus getPathStatus() {
            return this._pathStatus;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ConfiguredLsp.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ConfiguredLsp.bindingEquals(this, obj);
        }

        public String toString() {
            return ConfiguredLsp.bindingToString(this);
        }
    }
}

