/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev191125.Loss;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathConstraints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.constraints.ExcludeRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.constraints.IncludeRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ConstraintsBuilder {
    private AddressFamily _addressFamily;
    private Uint32 _adminGroup;
    private DecimalBandwidth _bandwidth;
    private Uint8 _classType;
    private Delay _delay;
    private List<ExcludeRoute> _excludeRoute;
    private List<IncludeRoute> _includeRoute;
    private Delay _jitter;
    private Loss _loss;
    private Uint32 _metric;
    private Uint32 _teMetric;
    Map<Class<? extends Augmentation<Constraints>>, Augmentation<Constraints>> augmentation = Map.of();

    public ConstraintsBuilder() {
    }

    public ConstraintsBuilder(PathConstraints arg) {
        this._metric = arg.getMetric();
        this._teMetric = arg.getTeMetric();
        this._delay = arg.getDelay();
        this._jitter = arg.getJitter();
        this._loss = arg.getLoss();
        this._adminGroup = arg.getAdminGroup();
        this._addressFamily = arg.getAddressFamily();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._includeRoute = arg.getIncludeRoute();
        this._excludeRoute = arg.getExcludeRoute();
    }

    public ConstraintsBuilder(Constraints base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Constraints>>, Augmentation<Constraints>>(aug);
        }
        this._addressFamily = base.getAddressFamily();
        this._adminGroup = base.getAdminGroup();
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._delay = base.getDelay();
        this._excludeRoute = base.getExcludeRoute();
        this._includeRoute = base.getIncludeRoute();
        this._jitter = base.getJitter();
        this._loss = base.getLoss();
        this._metric = base.getMetric();
        this._teMetric = base.getTeMetric();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathConstraints) {
            this._metric = ((PathConstraints)arg).getMetric();
            this._teMetric = ((PathConstraints)arg).getTeMetric();
            this._delay = ((PathConstraints)arg).getDelay();
            this._jitter = ((PathConstraints)arg).getJitter();
            this._loss = ((PathConstraints)arg).getLoss();
            this._adminGroup = ((PathConstraints)arg).getAdminGroup();
            this._addressFamily = ((PathConstraints)arg).getAddressFamily();
            this._classType = ((PathConstraints)arg).getClassType();
            this._bandwidth = ((PathConstraints)arg).getBandwidth();
            this._includeRoute = ((PathConstraints)arg).getIncludeRoute();
            this._excludeRoute = ((PathConstraints)arg).getExcludeRoute();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PathConstraints]");
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public Uint32 getAdminGroup() {
        return this._adminGroup;
    }

    public DecimalBandwidth getBandwidth() {
        return this._bandwidth;
    }

    public Uint8 getClassType() {
        return this._classType;
    }

    public Delay getDelay() {
        return this._delay;
    }

    public List<ExcludeRoute> getExcludeRoute() {
        return this._excludeRoute;
    }

    public List<IncludeRoute> getIncludeRoute() {
        return this._includeRoute;
    }

    public Delay getJitter() {
        return this._jitter;
    }

    public Loss getLoss() {
        return this._loss;
    }

    public Uint32 getMetric() {
        return this._metric;
    }

    public Uint32 getTeMetric() {
        return this._teMetric;
    }

    public <E$$ extends Augmentation<Constraints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConstraintsBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public ConstraintsBuilder setAdminGroup(Uint32 value) {
        this._adminGroup = value;
        return this;
    }

    public ConstraintsBuilder setBandwidth(DecimalBandwidth value) {
        this._bandwidth = value;
        return this;
    }

    private static void checkClassTypeRange(short value) {
        if (value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..7]]", (int)value);
    }

    public ConstraintsBuilder setClassType(Uint8 value) {
        if (value != null) {
            ConstraintsBuilder.checkClassTypeRange(value.shortValue());
        }
        this._classType = value;
        return this;
    }

    public ConstraintsBuilder setDelay(Delay value) {
        this._delay = value;
        return this;
    }

    public ConstraintsBuilder setExcludeRoute(List<ExcludeRoute> values) {
        this._excludeRoute = values;
        return this;
    }

    public ConstraintsBuilder setIncludeRoute(List<IncludeRoute> values) {
        this._includeRoute = values;
        return this;
    }

    public ConstraintsBuilder setJitter(Delay value) {
        this._jitter = value;
        return this;
    }

    public ConstraintsBuilder setLoss(Loss value) {
        this._loss = value;
        return this;
    }

    public ConstraintsBuilder setMetric(Uint32 value) {
        this._metric = value;
        return this;
    }

    public ConstraintsBuilder setTeMetric(Uint32 value) {
        this._teMetric = value;
        return this;
    }

    public ConstraintsBuilder addAugmentation(Augmentation<Constraints> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Constraints>>, Augmentation<Constraints>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConstraintsBuilder removeAugmentation(Class<? extends Augmentation<Constraints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Constraints build() {
        return new ConstraintsImpl(this);
    }

    private static final class ConstraintsImpl
    extends AbstractAugmentable<Constraints>
    implements Constraints {
        private final AddressFamily _addressFamily;
        private final Uint32 _adminGroup;
        private final DecimalBandwidth _bandwidth;
        private final Uint8 _classType;
        private final Delay _delay;
        private final List<ExcludeRoute> _excludeRoute;
        private final List<IncludeRoute> _includeRoute;
        private final Delay _jitter;
        private final Loss _loss;
        private final Uint32 _metric;
        private final Uint32 _teMetric;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConstraintsImpl(ConstraintsBuilder base) {
            super(base.augmentation);
            this._addressFamily = base.getAddressFamily();
            this._adminGroup = base.getAdminGroup();
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._delay = base.getDelay();
            this._excludeRoute = CodeHelpers.emptyToNull(base.getExcludeRoute());
            this._includeRoute = CodeHelpers.emptyToNull(base.getIncludeRoute());
            this._jitter = base.getJitter();
            this._loss = base.getLoss();
            this._metric = base.getMetric();
            this._teMetric = base.getTeMetric();
        }

        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        public Uint32 getAdminGroup() {
            return this._adminGroup;
        }

        public DecimalBandwidth getBandwidth() {
            return this._bandwidth;
        }

        public Uint8 getClassType() {
            return this._classType;
        }

        public Delay getDelay() {
            return this._delay;
        }

        public List<ExcludeRoute> getExcludeRoute() {
            return this._excludeRoute;
        }

        public List<IncludeRoute> getIncludeRoute() {
            return this._includeRoute;
        }

        public Delay getJitter() {
            return this._jitter;
        }

        public Loss getLoss() {
            return this._loss;
        }

        public Uint32 getMetric() {
            return this._metric;
        }

        public Uint32 getTeMetric() {
            return this._teMetric;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Constraints.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Constraints.bindingEquals(this, obj);
        }

        public String toString() {
            return Constraints.bindingToString(this);
        }
    }
}

