package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * typedef path-status {
 *   type enumeration {
 *     enum reported {
 *       value 0;
 *     }
 *     enum configured {
 *       value 1;
 *     }
 *     enum updated {
 *       value 2;
 *     }
 *     enum sync {
 *       value 3;
 *     }
 *     enum failed {
 *       value 4;
 *     }
 *   }
 *   default reported;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum PathStatus implements EnumTypeObject {
    /**
     * TE Path is reported by the PCC
     */
    Reported(0, "reported"),
    
    /**
     * TE Path is configured but not setup
     */
    Configured(1, "configured"),
    
    /**
     * TE Path has been updated and need to be synchronized
     */
    Updated(2, "updated"),
    
    /**
     * TE Path is setup and synchronized
     */
    Sync(3, "sync"),
    
    /**
     * Attempt to configure TE Path on PCC failed
     */
    Failed(4, "failed")
    ;

    private final @NonNull String name;
    private final int value;

    private PathStatus(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding PathStatus item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable PathStatus forName(String name) {
        return switch (name) {
            case "reported" -> Reported;
            case "configured" -> Configured;
            case "updated" -> Updated;
            case "sync" -> Sync;
            case "failed" -> Failed;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding PathStatus item, or {@code null} if no such item exists
     */
    public static @Nullable PathStatus forValue(int intValue) {
        return switch (intValue) {
            case 0 -> Reported;
            case 1 -> Configured;
            case 2 -> Updated;
            case 3 -> Sync;
            case 4 -> Failed;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding PathStatus item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull PathStatus ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding PathStatus item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull PathStatus ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
