package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLspKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configured LSP per PCC node
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * grouping pcc-configured-lsp {
 *   list configured-lsp {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     leaf path-status {
 *       type path-status;
 *       config false;
 *     }
 *     container intended-path {
 *       leaf source {
 *         type inet:ip-address;
 *       }
 *       leaf destination {
 *         type inet:ip-address;
 *       }
 *       container constraints {
 *         uses algo:path-constraints;
 *       }
 *     }
 *     container computed-path {
 *       uses algo:path-descriptions;
 *       leaf computed-metric {
 *         type uint32;
 *       }
 *       leaf computation-status {
 *         type algo:computation-status;
 *       }
 *       config false;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PccConfiguredLsp
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcc-configured-lsp");

    @Override
    Class<? extends PccConfiguredLsp> implementedInterface();
    
    /**
     * Return configuredLsp, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of Configured LSP per PCC
     *     </code>
     * </pre>
     *
     * @return {@code Map<ConfiguredLspKey, ConfiguredLsp>} configuredLsp, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ConfiguredLspKey, ConfiguredLsp> getConfiguredLsp();
    
    /**
     * Return configuredLsp, or an empty list if it is not present.
     *
     * @return {@code Map<ConfiguredLspKey, ConfiguredLsp>} configuredLsp, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ConfiguredLspKey, ConfiguredLsp> nonnullConfiguredLsp() {
        return CodeHelpers.nonnull(getConfiguredLsp());
    }

}

