package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLspKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcepNodeConfig} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepNodeConfig createPcepNodeConfig(int fooXyzzy, int barBaz) {
 *         return new PcepNodeConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepNodeConfig, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepNodeConfig
 *
 */
@Generated("mdsal-binding-generator")
public class PcepNodeConfigBuilder {

    private Map<ConfiguredLspKey, ConfiguredLsp> _configuredLsp;



    /**
     * Construct an empty builder.
     */
    public PcepNodeConfigBuilder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link PccConfiguredLsp}.
     *
     * @param arg PccConfiguredLsp from which the builder should be initialized
     */
    public PcepNodeConfigBuilder(PccConfiguredLsp arg) {
        this._configuredLsp = arg.getConfiguredLsp();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PcepNodeConfig}.
     *
     * @param base PcepNodeConfig from which the builder should be initialized
     */
    public PcepNodeConfigBuilder(PcepNodeConfig base) {
        this._configuredLsp = base.getConfiguredLsp();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PccConfiguredLsp}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PccConfiguredLsp castArg) {
            this._configuredLsp = castArg.getConfiguredLsp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PccConfiguredLsp]");
    }


    /**
     * Return current value associated with the property corresponding to {@link PcepNodeConfig#getConfiguredLsp()}.
     *
     * @return current value
     */
    public Map<ConfiguredLspKey, ConfiguredLsp> getConfiguredLsp() {
        return _configuredLsp;
    }

    
    /**
     * Set the property corresponding to {@link PcepNodeConfig#getConfiguredLsp()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PcepNodeConfigBuilder setConfiguredLsp(final Map<ConfiguredLspKey, ConfiguredLsp> values) {
        this._configuredLsp = values;
        return this;
    }
    

    /**
     * A new {@link PcepNodeConfig} instance.
     *
     * @return A new {@link PcepNodeConfig} instance.
     */
    public @NonNull PcepNodeConfig build() {
        return new PcepNodeConfigImpl(this);
    }

    private static final class PcepNodeConfigImpl
        implements PcepNodeConfig {
    
        private final Map<ConfiguredLspKey, ConfiguredLsp> _configuredLsp;
    
        PcepNodeConfigImpl(PcepNodeConfigBuilder base) {
            this._configuredLsp = CodeHelpers.emptyToNull(base.getConfiguredLsp());
        }
    
        @Override
        public Map<ConfiguredLspKey, ConfiguredLsp> getConfiguredLsp() {
            return _configuredLsp;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepNodeConfig.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepNodeConfig.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepNodeConfig.bindingToString(this);
        }
    }
}
