package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the model of the Managed Path which allows the tunnels 
 * management by the PCE server. Copyright (c)2021 Orange. All rights reserved. 
 * This program and the accompanying materials are made available under the terms 
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * module pcep-server {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:pcep:server;
 *   prefix server;
 *   import network-topology {
 *     prefix nt;
 *     revision-date 2013-10-21;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import path-computation {
 *     prefix algo;
 *     revision-date 2022-03-24;
 *   }
 *   import network-topology-pcep {
 *     prefix topo;
 *     revision-date 2022-07-30;
 *   }
 *   import yang-ext {
 *     prefix ext;
 *     revision-date 2013-07-09;
 *   }
 *   revision 2022-03-21 {
 *   }
 *   revision 2021-07-20 {
 *   }
 *   typedef path-type {
 *     type enumeration {
 *       enum stateless {
 *         value 0;
 *       }
 *       enum pcc {
 *         value 1;
 *       }
 *       enum delegated {
 *         value 2;
 *       }
 *       enum initiated {
 *         value 3;
 *       }
 *     }
 *   }
 *   typedef path-status {
 *     type enumeration {
 *       enum reported {
 *         value 0;
 *       }
 *       enum configured {
 *         value 1;
 *       }
 *       enum updated {
 *         value 2;
 *       }
 *       enum sync {
 *         value 3;
 *       }
 *       enum failed {
 *         value 4;
 *       }
 *     }
 *     default reported;
 *   }
 *   grouping pcc-configured-lsp {
 *     list configured-lsp {
 *       key name;
 *       leaf name {
 *         type string;
 *       }
 *       leaf path-status {
 *         type path-status;
 *         config false;
 *       }
 *       container intended-path {
 *         leaf source {
 *           type inet:ip-address;
 *         }
 *         leaf destination {
 *           type inet:ip-address;
 *         }
 *         container constraints {
 *           uses algo:path-constraints;
 *         }
 *       }
 *       container computed-path {
 *         uses algo:path-descriptions;
 *         leaf computed-metric {
 *           type uint32;
 *         }
 *         leaf computation-status {
 *           type algo:computation-status;
 *         }
 *         config false;
 *       }
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node/topo:path-computation-client {
 *     uses pcc-configured-lsp;
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node {
 *     when ../nt:topology-types/topo:topology-pcep;
 *     ext:augment-identifier pcep-node-config;
 *     uses pcc-configured-lsp;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepServerData
    extends
    DataRoot
{





}

