package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.PathStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.PccConfiguredLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of Configured LSP per PCC
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * list configured-lsp {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   leaf path-status {
 *     type path-status;
 *     config false;
 *   }
 *   container intended-path {
 *     leaf source {
 *       type inet:ip-address;
 *     }
 *     leaf destination {
 *       type inet:ip-address;
 *     }
 *     container constraints {
 *       uses algo:path-constraints;
 *     }
 *   }
 *   container computed-path {
 *     uses algo:path-descriptions;
 *     leaf computed-metric {
 *       type uint32;
 *     }
 *     leaf computation-status {
 *       type algo:computation-status;
 *     }
 *     config false;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ConfiguredLspBuilder}.
 * @see ConfiguredLspBuilder
 * @see ConfiguredLspKey
 *
 */
@Generated("mdsal-binding-generator")
public interface ConfiguredLsp
    extends
    ChildOf<PccConfiguredLsp>,
    Augmentable<ConfiguredLsp>,
    Identifiable<ConfiguredLspKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("configured-lsp");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.@NonNull ConfiguredLsp obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getComputedPath());
        result = prime * result + Objects.hashCode(obj.getIntendedPath());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getPathStatus());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.@NonNull ConfiguredLsp thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp.class, obj);
        return other != null
            && Objects.equals(thisObj.getName(), other.getName())
            && Objects.equals(thisObj.getComputedPath(), other.getComputedPath())
            && Objects.equals(thisObj.getIntendedPath(), other.getIntendedPath())
            && Objects.equals(thisObj.getPathStatus(), other.getPathStatus())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.@NonNull ConfiguredLsp obj) {
        final var helper = MoreObjects.toStringHelper("ConfiguredLsp");
        CodeHelpers.appendValue(helper, "computedPath", obj.getComputedPath());
        CodeHelpers.appendValue(helper, "intendedPath", obj.getIntendedPath());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "pathStatus", obj.getPathStatus());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ConfiguredLspKey key();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return pathStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Status of TE Path
     *     </code>
     * </pre>
     *
     * @return {@code PathStatus} pathStatus, or {@code null} if it is not present.
     *
     */
    PathStatus getPathStatus();
    
    /**
     * Return pathStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Status of TE Path
     *     </code>
     * </pre>
     *
     * @return {@code PathStatus} pathStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if pathStatus is not present
     *
     */
    default @NonNull PathStatus requirePathStatus() {
        return CodeHelpers.require(getPathStatus(), "pathstatus");
    }
    
    /**
     * Return intendedPath, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Intended Path constraints
     *     </code>
     * </pre>
     *
     * @return {@code IntendedPath} intendedPath, or {@code null} if it is not present.
     *
     */
    IntendedPath getIntendedPath();
    
    /**
     * Return intendedPath, or an empty instance if it is not present.
     *
     * @return {@code IntendedPath} intendedPath, or an empty instance if it is not present.
     *
     */
    @NonNull IntendedPath nonnullIntendedPath();
    
    /**
     * Return computedPath, or {@code null} if it is not present.
     *
     * @return {@code ComputedPath} computedPath, or {@code null} if it is not present.
     *
     */
    ComputedPath getComputedPath();
    
    /**
     * Return computedPath, or an empty instance if it is not present.
     *
     * @return {@code ComputedPath} computedPath, or an empty instance if it is not present.
     *
     */
    @NonNull ComputedPath nonnullComputedPath();

}

