package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.PathStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link ConfiguredLsp} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ConfiguredLsp createConfiguredLsp(int fooXyzzy, int barBaz) {
 *         return new ConfiguredLspBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ConfiguredLsp, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ConfiguredLsp
 *
 */
@Generated("mdsal-binding-generator")
public class ConfiguredLspBuilder {

    private ComputedPath _computedPath;
    private IntendedPath _intendedPath;
    private String _name;
    private PathStatus _pathStatus;
    private ConfiguredLspKey key;


    Map<Class<? extends Augmentation<ConfiguredLsp>>, Augmentation<ConfiguredLsp>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfiguredLspBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link ConfiguredLsp}.
     *
     * @param base ConfiguredLsp from which the builder should be initialized
     */
    public ConfiguredLspBuilder(ConfiguredLsp base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._computedPath = base.getComputedPath();
        this._intendedPath = base.getIntendedPath();
        this._pathStatus = base.getPathStatus();
    }



    /**
     * Return current value associated with the property corresponding to {@link ConfiguredLsp#key()}.
     *
     * @return current value
     */
    public ConfiguredLspKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConfiguredLsp#getComputedPath()}.
     *
     * @return current value
     */
    public ComputedPath getComputedPath() {
        return _computedPath;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConfiguredLsp#getIntendedPath()}.
     *
     * @return current value
     */
    public IntendedPath getIntendedPath() {
        return _intendedPath;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConfiguredLsp#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ConfiguredLsp#getPathStatus()}.
     *
     * @return current value
     */
    public PathStatus getPathStatus() {
        return _pathStatus;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ConfiguredLsp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link ConfiguredLsp#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public ConfiguredLspBuilder withKey(final ConfiguredLspKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConfiguredLsp#getComputedPath()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfiguredLspBuilder setComputedPath(final ComputedPath value) {
        this._computedPath = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConfiguredLsp#getIntendedPath()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfiguredLspBuilder setIntendedPath(final IntendedPath value) {
        this._intendedPath = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConfiguredLsp#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfiguredLspBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ConfiguredLsp#getPathStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfiguredLspBuilder setPathStatus(final PathStatus value) {
        this._pathStatus = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfiguredLspBuilder addAugmentation(Augmentation<ConfiguredLsp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfiguredLspBuilder removeAugmentation(Class<? extends Augmentation<ConfiguredLsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ConfiguredLsp} instance.
     *
     * @return A new {@link ConfiguredLsp} instance.
     */
    public @NonNull ConfiguredLsp build() {
        return new ConfiguredLspImpl(this);
    }

    private static final class ConfiguredLspImpl
        extends AbstractAugmentable<ConfiguredLsp>
        implements ConfiguredLsp {
    
        private final ComputedPath _computedPath;
        private final IntendedPath _intendedPath;
        private final String _name;
        private final PathStatus _pathStatus;
        private final ConfiguredLspKey key;
    
        ConfiguredLspImpl(ConfiguredLspBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ConfiguredLspKey(base.getName());
            }
            this._name = key.getName();
            this._computedPath = base.getComputedPath();
            this._intendedPath = base.getIntendedPath();
            this._pathStatus = base.getPathStatus();
        }
    
        @Override
        public ConfiguredLspKey key() {
            return key;
        }
        
        @Override
        public ComputedPath getComputedPath() {
            return _computedPath;
        }
        
        @Override
        public IntendedPath getIntendedPath() {
            return _intendedPath;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public PathStatus getPathStatus() {
            return _pathStatus;
        }
    
        @Override
        public ComputedPath nonnullComputedPath() {
            return Objects.requireNonNullElse(getComputedPath(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPathBuilder.empty());
        }
        
        @Override
        public IntendedPath nonnullIntendedPath() {
            return Objects.requireNonNullElse(getIntendedPath(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPathBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ConfiguredLsp.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ConfiguredLsp.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ConfiguredLsp.bindingToString(this);
        }
    }
}
