package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathDescriptions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * container computed-path {
 *   uses algo:path-descriptions;
 *   leaf computed-metric {
 *     type uint32;
 *   }
 *   leaf computation-status {
 *     type algo:computation-status;
 *   }
 *   config false;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ComputedPathBuilder}.
 * @see ComputedPathBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ComputedPath
    extends
    ChildOf<ConfiguredLsp>,
    Augmentable<ComputedPath>,
    PathDescriptions
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("computed-path");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull ComputedPath obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getComputationStatus());
        result = prime * result + Objects.hashCode(obj.getComputedMetric());
        result = prime * result + Objects.hashCode(obj.getPathDescription());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull ComputedPath thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath.class, obj);
        return other != null
            && Objects.equals(thisObj.getComputedMetric(), other.getComputedMetric())
            && Objects.equals(thisObj.getComputationStatus(), other.getComputationStatus())
            && Objects.equals(thisObj.getPathDescription(), other.getPathDescription())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull ComputedPath obj) {
        final var helper = MoreObjects.toStringHelper("ComputedPath");
        CodeHelpers.appendValue(helper, "computationStatus", obj.getComputationStatus());
        CodeHelpers.appendValue(helper, "computedMetric", obj.getComputedMetric());
        CodeHelpers.appendValue(helper, "pathDescription", obj.getPathDescription());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return computedMetric, or {@code null} if it is not present.
     *
     * @return {@code Uint32} computedMetric, or {@code null} if it is not present.
     *
     */
    Uint32 getComputedMetric();
    
    /**
     * Return computedMetric, guaranteed to be non-null.
     *
     * @return {@code Uint32} computedMetric, guaranteed to be non-null.
     * @throws NoSuchElementException if computedMetric is not present
     *
     */
    default @NonNull Uint32 requireComputedMetric() {
        return CodeHelpers.require(getComputedMetric(), "computedmetric");
    }
    
    /**
     * Return computationStatus, or {@code null} if it is not present.
     *
     * @return {@code ComputationStatus} computationStatus, or {@code null} if it is not present.
     *
     */
    ComputationStatus getComputationStatus();
    
    /**
     * Return computationStatus, guaranteed to be non-null.
     *
     * @return {@code ComputationStatus} computationStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if computationStatus is not present
     *
     */
    default @NonNull ComputationStatus requireComputationStatus() {
        return CodeHelpers.require(getComputationStatus(), "computationstatus");
    }

}

