package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathDescriptions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.descriptions.PathDescription;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link ComputedPath} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ComputedPath createComputedPath(int fooXyzzy, int barBaz) {
 *         return new ComputedPathBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ComputedPath, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ComputedPath
 *
 */
@Generated("mdsal-binding-generator")
public class ComputedPathBuilder {

    private ComputationStatus _computationStatus;
    private Uint32 _computedMetric;
    private List<PathDescription> _pathDescription;


    Map<Class<? extends Augmentation<ComputedPath>>, Augmentation<ComputedPath>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ComputedPathBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PathDescriptions}.
     *
     * @param arg PathDescriptions from which the builder should be initialized
     */
    public ComputedPathBuilder(PathDescriptions arg) {
        this._pathDescription = arg.getPathDescription();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ComputedPath}.
     *
     * @param base ComputedPath from which the builder should be initialized
     */
    public ComputedPathBuilder(ComputedPath base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._computationStatus = base.getComputationStatus();
        this._computedMetric = base.getComputedMetric();
        this._pathDescription = base.getPathDescription();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PathDescriptions}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathDescriptions castArg) {
            this._pathDescription = castArg.getPathDescription();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PathDescriptions]");
    }

    private static final class LazyEmpty {
        static final @NonNull ComputedPath INSTANCE = new ComputedPathBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ComputedPath.
     *
     * @return An empty {@link ComputedPath}
     */
    public static @NonNull ComputedPath empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ComputedPath#getComputationStatus()}.
     *
     * @return current value
     */
    public ComputationStatus getComputationStatus() {
        return _computationStatus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ComputedPath#getComputedMetric()}.
     *
     * @return current value
     */
    public Uint32 getComputedMetric() {
        return _computedMetric;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ComputedPath#getPathDescription()}.
     *
     * @return current value
     */
    public List<PathDescription> getPathDescription() {
        return _pathDescription;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ComputedPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ComputedPath#getComputationStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComputedPathBuilder setComputationStatus(final ComputationStatus value) {
        this._computationStatus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ComputedPath#getComputedMetric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComputedPathBuilder setComputedMetric(final Uint32 value) {
        this._computedMetric = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ComputedPath#getPathDescription()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ComputedPathBuilder setPathDescription(final List<PathDescription> values) {
        this._pathDescription = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ComputedPathBuilder addAugmentation(Augmentation<ComputedPath> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ComputedPathBuilder removeAugmentation(Class<? extends Augmentation<ComputedPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ComputedPath} instance.
     *
     * @return A new {@link ComputedPath} instance.
     */
    public @NonNull ComputedPath build() {
        return new ComputedPathImpl(this);
    }

    private static final class ComputedPathImpl
        extends AbstractAugmentable<ComputedPath>
        implements ComputedPath {
    
        private final ComputationStatus _computationStatus;
        private final Uint32 _computedMetric;
        private final List<PathDescription> _pathDescription;
    
        ComputedPathImpl(ComputedPathBuilder base) {
            super(base.augmentation);
            this._computationStatus = base.getComputationStatus();
            this._computedMetric = base.getComputedMetric();
            this._pathDescription = CodeHelpers.emptyToNull(base.getPathDescription());
        }
    
        @Override
        public ComputationStatus getComputationStatus() {
            return _computationStatus;
        }
        
        @Override
        public Uint32 getComputedMetric() {
            return _computedMetric;
        }
        
        @Override
        public List<PathDescription> getPathDescription() {
            return _pathDescription;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ComputedPath.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ComputedPath.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ComputedPath.bindingToString(this);
        }
    }
}
