package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.ConfiguredLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Intended Path constraints
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * container intended-path {
 *   leaf source {
 *     type inet:ip-address;
 *   }
 *   leaf destination {
 *     type inet:ip-address;
 *   }
 *   container constraints {
 *     uses algo:path-constraints;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link IntendedPathBuilder}.
 * @see IntendedPathBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface IntendedPath
    extends
    ChildOf<ConfiguredLsp>,
    Augmentable<IntendedPath>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("intended-path");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull IntendedPath obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConstraints());
        result = prime * result + Objects.hashCode(obj.getDestination());
        result = prime * result + Objects.hashCode(obj.getSource());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull IntendedPath thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath.class, obj);
        return other != null
            && Objects.equals(thisObj.getConstraints(), other.getConstraints())
            && Objects.equals(thisObj.getDestination(), other.getDestination())
            && Objects.equals(thisObj.getSource(), other.getSource())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.@NonNull IntendedPath obj) {
        final var helper = MoreObjects.toStringHelper("IntendedPath");
        CodeHelpers.appendValue(helper, "constraints", obj.getConstraints());
        CodeHelpers.appendValue(helper, "destination", obj.getDestination());
        CodeHelpers.appendValue(helper, "source", obj.getSource());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return source, or {@code null} if it is not present.
     *
     * @return {@code IpAddress} source, or {@code null} if it is not present.
     *
     */
    IpAddress getSource();
    
    /**
     * Return source, guaranteed to be non-null.
     *
     * @return {@code IpAddress} source, guaranteed to be non-null.
     * @throws NoSuchElementException if source is not present
     *
     */
    default @NonNull IpAddress requireSource() {
        return CodeHelpers.require(getSource(), "source");
    }
    
    /**
     * Return destination, or {@code null} if it is not present.
     *
     * @return {@code IpAddress} destination, or {@code null} if it is not present.
     *
     */
    IpAddress getDestination();
    
    /**
     * Return destination, guaranteed to be non-null.
     *
     * @return {@code IpAddress} destination, guaranteed to be non-null.
     * @throws NoSuchElementException if destination is not present
     *
     */
    default @NonNull IpAddress requireDestination() {
        return CodeHelpers.require(getDestination(), "destination");
    }
    
    /**
     * Return constraints, or {@code null} if it is not present.
     *
     * @return {@code Constraints} constraints, or {@code null} if it is not present.
     *
     */
    Constraints getConstraints();
    
    /**
     * Return constraints, or an empty instance if it is not present.
     *
     * @return {@code Constraints} constraints, or an empty instance if it is not present.
     *
     */
    @NonNull Constraints nonnullConstraints();

}

