package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link IntendedPath} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     IntendedPath createIntendedPath(int fooXyzzy, int barBaz) {
 *         return new IntendedPathBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of IntendedPath, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see IntendedPath
 *
 */
@Generated("mdsal-binding-generator")
public class IntendedPathBuilder {

    private Constraints _constraints;
    private IpAddress _destination;
    private IpAddress _source;


    Map<Class<? extends Augmentation<IntendedPath>>, Augmentation<IntendedPath>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public IntendedPathBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link IntendedPath}.
     *
     * @param base IntendedPath from which the builder should be initialized
     */
    public IntendedPathBuilder(IntendedPath base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._constraints = base.getConstraints();
        this._destination = base.getDestination();
        this._source = base.getSource();
    }


    private static final class LazyEmpty {
        static final @NonNull IntendedPath INSTANCE = new IntendedPathBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of IntendedPath.
     *
     * @return An empty {@link IntendedPath}
     */
    public static @NonNull IntendedPath empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link IntendedPath#getConstraints()}.
     *
     * @return current value
     */
    public Constraints getConstraints() {
        return _constraints;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link IntendedPath#getDestination()}.
     *
     * @return current value
     */
    public IpAddress getDestination() {
        return _destination;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link IntendedPath#getSource()}.
     *
     * @return current value
     */
    public IpAddress getSource() {
        return _source;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<IntendedPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link IntendedPath#getConstraints()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public IntendedPathBuilder setConstraints(final Constraints value) {
        this._constraints = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link IntendedPath#getDestination()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public IntendedPathBuilder setDestination(final IpAddress value) {
        this._destination = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link IntendedPath#getSource()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public IntendedPathBuilder setSource(final IpAddress value) {
        this._source = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public IntendedPathBuilder addAugmentation(Augmentation<IntendedPath> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public IntendedPathBuilder removeAugmentation(Class<? extends Augmentation<IntendedPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link IntendedPath} instance.
     *
     * @return A new {@link IntendedPath} instance.
     */
    public @NonNull IntendedPath build() {
        return new IntendedPathImpl(this);
    }

    private static final class IntendedPathImpl
        extends AbstractAugmentable<IntendedPath>
        implements IntendedPath {
    
        private final Constraints _constraints;
        private final IpAddress _destination;
        private final IpAddress _source;
    
        IntendedPathImpl(IntendedPathBuilder base) {
            super(base.augmentation);
            this._constraints = base.getConstraints();
            this._destination = base.getDestination();
            this._source = base.getSource();
        }
    
        @Override
        public Constraints getConstraints() {
            return _constraints;
        }
        
        @Override
        public IpAddress getDestination() {
            return _destination;
        }
        
        @Override
        public IpAddress getSource() {
            return _source;
        }
    
        @Override
        public Constraints nonnullConstraints() {
            return Objects.requireNonNullElse(getConstraints(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.ConstraintsBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = IntendedPath.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return IntendedPath.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return IntendedPath.bindingToString(this);
        }
    }
}
