package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathConstraints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.IntendedPath;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-server</b>
 * <pre>
 * container constraints {
 *   uses algo:path-constraints;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ConstraintsBuilder}.
 * @see ConstraintsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Constraints
    extends
    ChildOf<IntendedPath>,
    Augmentable<Constraints>,
    PathConstraints
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("constraints");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.@NonNull Constraints obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddressFamily());
        result = prime * result + Objects.hashCode(obj.getAdminGroup());
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getDelay());
        result = prime * result + Objects.hashCode(obj.getExcludeRoute());
        result = prime * result + Objects.hashCode(obj.getIncludeRoute());
        result = prime * result + Objects.hashCode(obj.getJitter());
        result = prime * result + Objects.hashCode(obj.getLoss());
        result = prime * result + Objects.hashCode(obj.getMetric());
        result = prime * result + Objects.hashCode(obj.getTeMetric());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.@NonNull Constraints thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.Constraints.class, obj);
        return other != null
            && Objects.equals(thisObj.getAdminGroup(), other.getAdminGroup())
            && Objects.equals(thisObj.getBandwidth(), other.getBandwidth())
            && Objects.equals(thisObj.getClassType(), other.getClassType())
            && Objects.equals(thisObj.getDelay(), other.getDelay())
            && Objects.equals(thisObj.getJitter(), other.getJitter())
            && Objects.equals(thisObj.getLoss(), other.getLoss())
            && Objects.equals(thisObj.getMetric(), other.getMetric())
            && Objects.equals(thisObj.getTeMetric(), other.getTeMetric())
            && Objects.equals(thisObj.getAddressFamily(), other.getAddressFamily())
            && Objects.equals(thisObj.getExcludeRoute(), other.getExcludeRoute())
            && Objects.equals(thisObj.getIncludeRoute(), other.getIncludeRoute())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path.@NonNull Constraints obj) {
        final var helper = MoreObjects.toStringHelper("Constraints");
        CodeHelpers.appendValue(helper, "addressFamily", obj.getAddressFamily());
        CodeHelpers.appendValue(helper, "adminGroup", obj.getAdminGroup());
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "delay", obj.getDelay());
        CodeHelpers.appendValue(helper, "excludeRoute", obj.getExcludeRoute());
        CodeHelpers.appendValue(helper, "includeRoute", obj.getIncludeRoute());
        CodeHelpers.appendValue(helper, "jitter", obj.getJitter());
        CodeHelpers.appendValue(helper, "loss", obj.getLoss());
        CodeHelpers.appendValue(helper, "metric", obj.getMetric());
        CodeHelpers.appendValue(helper, "teMetric", obj.getTeMetric());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

