package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.intended.path;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.DecimalBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Delay;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.graph.rev220720.Loss;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathConstraints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.constraints.ExcludeRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.constraints.IncludeRoute;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link Constraints} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Constraints createConstraints(int fooXyzzy, int barBaz) {
 *         return new ConstraintsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Constraints, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Constraints
 *
 */
@Generated("mdsal-binding-generator")
public class ConstraintsBuilder {

    private AddressFamily _addressFamily;
    private Uint32 _adminGroup;
    private DecimalBandwidth _bandwidth;
    private Uint8 _classType;
    private Delay _delay;
    private List<ExcludeRoute> _excludeRoute;
    private List<IncludeRoute> _includeRoute;
    private Delay _jitter;
    private Loss _loss;
    private Uint32 _metric;
    private Uint32 _teMetric;


    Map<Class<? extends Augmentation<Constraints>>, Augmentation<Constraints>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConstraintsBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PathConstraints}.
     *
     * @param arg PathConstraints from which the builder should be initialized
     */
    public ConstraintsBuilder(PathConstraints arg) {
        this._metric = arg.getMetric();
        this._teMetric = arg.getTeMetric();
        this._delay = arg.getDelay();
        this._jitter = arg.getJitter();
        this._loss = arg.getLoss();
        this._adminGroup = arg.getAdminGroup();
        this._addressFamily = arg.getAddressFamily();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._includeRoute = arg.getIncludeRoute();
        this._excludeRoute = arg.getExcludeRoute();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Constraints}.
     *
     * @param base Constraints from which the builder should be initialized
     */
    public ConstraintsBuilder(Constraints base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._addressFamily = base.getAddressFamily();
        this._adminGroup = base.getAdminGroup();
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._delay = base.getDelay();
        this._excludeRoute = base.getExcludeRoute();
        this._includeRoute = base.getIncludeRoute();
        this._jitter = base.getJitter();
        this._loss = base.getLoss();
        this._metric = base.getMetric();
        this._teMetric = base.getTeMetric();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PathConstraints}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathConstraints castArg) {
            this._metric = castArg.getMetric();
            this._teMetric = castArg.getTeMetric();
            this._delay = castArg.getDelay();
            this._jitter = castArg.getJitter();
            this._loss = castArg.getLoss();
            this._adminGroup = castArg.getAdminGroup();
            this._addressFamily = castArg.getAddressFamily();
            this._classType = castArg.getClassType();
            this._bandwidth = castArg.getBandwidth();
            this._includeRoute = castArg.getIncludeRoute();
            this._excludeRoute = castArg.getExcludeRoute();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PathConstraints]");
    }

    private static final class LazyEmpty {
        static final @NonNull Constraints INSTANCE = new ConstraintsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Constraints.
     *
     * @return An empty {@link Constraints}
     */
    public static @NonNull Constraints empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Constraints#getAddressFamily()}.
     *
     * @return current value
     */
    public AddressFamily getAddressFamily() {
        return _addressFamily;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getAdminGroup()}.
     *
     * @return current value
     */
    public Uint32 getAdminGroup() {
        return _adminGroup;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getBandwidth()}.
     *
     * @return current value
     */
    public DecimalBandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getClassType()}.
     *
     * @return current value
     */
    public Uint8 getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getDelay()}.
     *
     * @return current value
     */
    public Delay getDelay() {
        return _delay;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getExcludeRoute()}.
     *
     * @return current value
     */
    public List<ExcludeRoute> getExcludeRoute() {
        return _excludeRoute;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getIncludeRoute()}.
     *
     * @return current value
     */
    public List<IncludeRoute> getIncludeRoute() {
        return _includeRoute;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getJitter()}.
     *
     * @return current value
     */
    public Delay getJitter() {
        return _jitter;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getLoss()}.
     *
     * @return current value
     */
    public Loss getLoss() {
        return _loss;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getMetric()}.
     *
     * @return current value
     */
    public Uint32 getMetric() {
        return _metric;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Constraints#getTeMetric()}.
     *
     * @return current value
     */
    public Uint32 getTeMetric() {
        return _teMetric;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Constraints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Constraints#getAddressFamily()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setAddressFamily(final AddressFamily value) {
        this._addressFamily = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getAdminGroup()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setAdminGroup(final Uint32 value) {
        this._adminGroup = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setBandwidth(final DecimalBandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    private static void checkClassTypeRange(final short value) {
        if (value <= (short)7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..7]]", value);
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setClassType(final Uint8 value) {
        if (value != null) {
            checkClassTypeRange(value.shortValue());
            
        }
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getDelay()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setDelay(final Delay value) {
        this._delay = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getExcludeRoute()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ConstraintsBuilder setExcludeRoute(final List<ExcludeRoute> values) {
        this._excludeRoute = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Constraints#getIncludeRoute()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ConstraintsBuilder setIncludeRoute(final List<IncludeRoute> values) {
        this._includeRoute = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Constraints#getJitter()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setJitter(final Delay value) {
        this._jitter = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getLoss()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setLoss(final Loss value) {
        this._loss = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getMetric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setMetric(final Uint32 value) {
        this._metric = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Constraints#getTeMetric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConstraintsBuilder setTeMetric(final Uint32 value) {
        this._teMetric = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConstraintsBuilder addAugmentation(Augmentation<Constraints> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConstraintsBuilder removeAugmentation(Class<? extends Augmentation<Constraints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Constraints} instance.
     *
     * @return A new {@link Constraints} instance.
     */
    public @NonNull Constraints build() {
        return new ConstraintsImpl(this);
    }

    private static final class ConstraintsImpl
        extends AbstractAugmentable<Constraints>
        implements Constraints {
    
        private final AddressFamily _addressFamily;
        private final Uint32 _adminGroup;
        private final DecimalBandwidth _bandwidth;
        private final Uint8 _classType;
        private final Delay _delay;
        private final List<ExcludeRoute> _excludeRoute;
        private final List<IncludeRoute> _includeRoute;
        private final Delay _jitter;
        private final Loss _loss;
        private final Uint32 _metric;
        private final Uint32 _teMetric;
    
        ConstraintsImpl(ConstraintsBuilder base) {
            super(base.augmentation);
            this._addressFamily = base.getAddressFamily();
            this._adminGroup = base.getAdminGroup();
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._delay = base.getDelay();
            this._excludeRoute = CodeHelpers.emptyToNull(base.getExcludeRoute());
            this._includeRoute = CodeHelpers.emptyToNull(base.getIncludeRoute());
            this._jitter = base.getJitter();
            this._loss = base.getLoss();
            this._metric = base.getMetric();
            this._teMetric = base.getTeMetric();
        }
    
        @Override
        public AddressFamily getAddressFamily() {
            return _addressFamily;
        }
        
        @Override
        public Uint32 getAdminGroup() {
            return _adminGroup;
        }
        
        @Override
        public DecimalBandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public Uint8 getClassType() {
            return _classType;
        }
        
        @Override
        public Delay getDelay() {
            return _delay;
        }
        
        @Override
        public List<ExcludeRoute> getExcludeRoute() {
            return _excludeRoute;
        }
        
        @Override
        public List<IncludeRoute> getIncludeRoute() {
            return _includeRoute;
        }
        
        @Override
        public Delay getJitter() {
            return _jitter;
        }
        
        @Override
        public Loss getLoss() {
            return _loss;
        }
        
        @Override
        public Uint32 getMetric() {
            return _metric;
        }
        
        @Override
        public Uint32 getTeMetric() {
            return _teMetric;
        }
    
        
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Constraints.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Constraints.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Constraints.bindingToString(this);
        }
    }
}
