/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.ComputationStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.PathDescriptions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.path.computation.rev220324.path.descriptions.PathDescription;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.server.rev220321.pcc.configured.lsp.configured.lsp.ComputedPath;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ComputedPathBuilder {
    private ComputationStatus _computationStatus;
    private Uint32 _computedMetric;
    private List<PathDescription> _pathDescription;
    Map<Class<? extends Augmentation<ComputedPath>>, Augmentation<ComputedPath>> augmentation = Map.of();

    public ComputedPathBuilder() {
    }

    public ComputedPathBuilder(PathDescriptions arg) {
        this._pathDescription = arg.getPathDescription();
    }

    public ComputedPathBuilder(ComputedPath base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ComputedPath>>, Augmentation<ComputedPath>>(aug);
        }
        this._computationStatus = base.getComputationStatus();
        this._computedMetric = base.getComputedMetric();
        this._pathDescription = base.getPathDescription();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathDescriptions) {
            PathDescriptions castArg = (PathDescriptions)arg;
            this._pathDescription = castArg.getPathDescription();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PathDescriptions]");
    }

    public static @NonNull ComputedPath empty() {
        return LazyEmpty.INSTANCE;
    }

    public ComputationStatus getComputationStatus() {
        return this._computationStatus;
    }

    public Uint32 getComputedMetric() {
        return this._computedMetric;
    }

    public List<PathDescription> getPathDescription() {
        return this._pathDescription;
    }

    public <E$$ extends Augmentation<ComputedPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ComputedPathBuilder setComputationStatus(ComputationStatus value) {
        this._computationStatus = value;
        return this;
    }

    public ComputedPathBuilder setComputedMetric(Uint32 value) {
        this._computedMetric = value;
        return this;
    }

    public ComputedPathBuilder setPathDescription(List<PathDescription> values) {
        this._pathDescription = values;
        return this;
    }

    public ComputedPathBuilder addAugmentation(Augmentation<ComputedPath> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ComputedPath>>, Augmentation<ComputedPath>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ComputedPathBuilder removeAugmentation(Class<? extends Augmentation<ComputedPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ComputedPath build() {
        return new ComputedPathImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull ComputedPath INSTANCE = new ComputedPathBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ComputedPathImpl
    extends AbstractAugmentable<ComputedPath>
    implements ComputedPath {
        private final ComputationStatus _computationStatus;
        private final Uint32 _computedMetric;
        private final List<PathDescription> _pathDescription;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ComputedPathImpl(ComputedPathBuilder base) {
            super(base.augmentation);
            this._computationStatus = base.getComputationStatus();
            this._computedMetric = base.getComputedMetric();
            this._pathDescription = CodeHelpers.emptyToNull(base.getPathDescription());
        }

        @Override
        public ComputationStatus getComputationStatus() {
            return this._computationStatus;
        }

        @Override
        public Uint32 getComputedMetric() {
            return this._computedMetric;
        }

        public List<PathDescription> getPathDescription() {
            return this._pathDescription;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ComputedPath.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ComputedPath.bindingEquals(this, obj);
        }

        public String toString() {
            return ComputedPath.bindingToString(this);
        }
    }
}

