/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.api;

import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public interface DataObjectModification<T extends DataObject>
extends org.opendaylight.yangtools.concepts.Identifiable<InstanceIdentifier.PathArgument> {
    @Override
    public InstanceIdentifier.PathArgument getIdentifier();

    @Nonnull
    public Class<T> getDataType();

    @Nonnull
    public ModificationType getModificationType();

    @Nullable
    public T getDataBefore();

    @Nullable
    public T getDataAfter();

    @Nonnull
    public Collection<? extends DataObjectModification<? extends DataObject>> getModifiedChildren();

    default public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> Collection<DataObjectModification<C>> getModifiedChildren(@Nonnull Class<H> caseType, @Nonnull Class<C> childType) {
        InstanceIdentifier.Item item = InstanceIdentifier.Item.of(caseType, childType);
        return Collections2.filter(this.getModifiedChildren(), mod -> item.equals(mod.getIdentifier()));
    }

    @Nullable
    default public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> DataObjectModification<C> getModifiedChildContainer(@Nonnull Class<H> caseType, @Nonnull Class<C> child) {
        return this.getModifiedChild(InstanceIdentifier.Item.of(caseType, child));
    }

    @Nullable
    public <C extends ChildOf<? super T>> DataObjectModification<C> getModifiedChildContainer(@Nonnull Class<C> var1);

    @Nullable
    public <C extends Augmentation<T> & DataObject> DataObjectModification<C> getModifiedAugmentation(@Nonnull Class<C> var1);

    public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> DataObjectModification<N> getModifiedChildListItem(@Nonnull Class<N> var1, @Nonnull K var2);

    default public <H extends ChoiceIn<? super T> & DataObject, C extends Identifiable<K> & ChildOf<? super H>, K extends Identifier<C>> DataObjectModification<C> getModifiedChildListItem(@Nonnull Class<H> caseType, @Nonnull Class<C> listItem, @Nonnull K listKey) {
        return this.getModifiedChild(InstanceIdentifier.IdentifiableItem.of(caseType, listItem, listKey));
    }

    @Nullable
    public DataObjectModification<? extends DataObject> getModifiedChild(InstanceIdentifier.PathArgument var1);

    public static enum ModificationType {
        SUBTREE_MODIFIED,
        WRITE,
        DELETE;

    }
}

