/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spec.reflect;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import org.opendaylight.mdsal.binding.spec.reflect.AugmentationFieldGetter;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingReflections {
    private static final long EXPIRATION_TIME = 60L;
    @RegEx
    private static final String ROOT_PACKAGE_PATTERN_STRING = "(org.opendaylight.yang.gen.v1.[a-z0-9_\\.]*\\.(?:rev[0-9][0-9][0-1][0-9][0-3][0-9]|norev))";
    private static final Pattern ROOT_PACKAGE_PATTERN = Pattern.compile("(org.opendaylight.yang.gen.v1.[a-z0-9_\\.]*\\.(?:rev[0-9][0-9][0-1][0-9][0-3][0-9]|norev))");
    private static final Logger LOG = LoggerFactory.getLogger(BindingReflections.class);
    private static final LoadingCache<Class<?>, Optional<QName>> CLASS_TO_QNAME = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build(new ClassToQNameLoader());

    private BindingReflections() {
        throw new UnsupportedOperationException("Utility class.");
    }

    public static Class<? extends Augmentable<?>> findAugmentationTarget(Class<? extends Augmentation<?>> augmentation) {
        return ClassLoaderUtils.findFirstGenericArgument(augmentation, Augmentation.class);
    }

    public static Class<?> findHierarchicalParent(Class<? extends ChildOf<?>> childClass) {
        return ClassLoaderUtils.findFirstGenericArgument(childClass, ChildOf.class);
    }

    public static Class<?> findHierarchicalParent(DataObject child) {
        if (child instanceof ChildOf) {
            return ClassLoaderUtils.findFirstGenericArgument(child.getImplementedInterface(), ChildOf.class);
        }
        return null;
    }

    public static QName findQName(Class<?> dataType) {
        return CLASS_TO_QNAME.getUnchecked(dataType).orNull();
    }

    public static boolean isRpcMethod(Method possibleMethod) {
        return possibleMethod != null && RpcService.class.isAssignableFrom(possibleMethod.getDeclaringClass()) && ListenableFuture.class.isAssignableFrom(possibleMethod.getReturnType()) && possibleMethod.getParameterTypes().length <= 2;
    }

    public static Optional<Class<?>> resolveRpcOutputClass(Method targetMethod) {
        Preconditions.checkState(BindingReflections.isRpcMethod(targetMethod), "Supplied method is not a RPC invocation method");
        Type futureType = targetMethod.getGenericReturnType();
        Type rpcResultType = ClassLoaderUtils.getFirstGenericParameter(futureType);
        Type rpcResultArgument = ClassLoaderUtils.getFirstGenericParameter(rpcResultType);
        if (rpcResultArgument instanceof Class && !Void.class.equals((Object)rpcResultArgument)) {
            return Optional.of((Class)rpcResultArgument);
        }
        return Optional.absent();
    }

    public static Optional<Class<? extends DataContainer>> resolveRpcInputClass(Method targetMethod) {
        for (Class<?> clazz : targetMethod.getParameterTypes()) {
            if (!DataContainer.class.isAssignableFrom(clazz)) continue;
            return Optional.of(clazz);
        }
        return Optional.absent();
    }

    public static QName getQName(Class<? extends BaseIdentity> context) {
        return BindingReflections.findQName(context);
    }

    public static boolean isAugmentationChild(Class<?> clazz) {
        String parentModelPackage;
        Preconditions.checkArgument(clazz != null);
        Class<?> parent = BindingReflections.findHierarchicalParent(clazz);
        if (parent == null) {
            LOG.debug("Did not find a parent for class {}", (Object)clazz);
            return false;
        }
        String clazzModelPackage = BindingReflections.getModelRootPackageName(clazz.getPackage());
        return !clazzModelPackage.equals(parentModelPackage = BindingReflections.getModelRootPackageName(parent.getPackage()));
    }

    public static String getModelRootPackageName(Package pkg) {
        return BindingReflections.getModelRootPackageName(pkg.getName());
    }

    public static String getModelRootPackageName(String name) {
        Preconditions.checkArgument(name != null, "Package name should not be null.");
        Preconditions.checkArgument(name.startsWith("org.opendaylight.yang.gen.v1"), "Package name not starting with %s, is: %s", (Object)"org.opendaylight.yang.gen.v1", (Object)name);
        Matcher match = ROOT_PACKAGE_PATTERN.matcher(name);
        Preconditions.checkArgument(match.find(), "Package name '%s' does not match required pattern '%s'", (Object)name, (Object)ROOT_PACKAGE_PATTERN_STRING);
        return match.group(0);
    }

    public static QNameModule getQNameModule(Class<?> clz) {
        if (DataContainer.class.isAssignableFrom(clz) || BaseIdentity.class.isAssignableFrom(clz) || Action.class.isAssignableFrom(clz)) {
            return BindingReflections.findQName(clz).getModule();
        }
        try {
            return BindingReflections.getModuleInfo(clz).getName().getModule();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get QName of defining model.", e);
        }
    }

    @Deprecated
    public static QNameModule getQNameModule(YangModuleInfo modInfo) {
        return modInfo.getName().getModule();
    }

    public static YangModuleInfo getModuleInfo(Class<?> cls) throws Exception {
        Preconditions.checkArgument(cls != null);
        String packageName = BindingReflections.getModelRootPackageName(cls.getPackage());
        String potentialClassName = BindingReflections.getModuleInfoClassName(packageName);
        return ClassLoaderUtils.callWithClassLoader(cls.getClassLoader(), () -> {
            Class<?> moduleInfoClass = Thread.currentThread().getContextClassLoader().loadClass(potentialClassName);
            return (YangModuleInfo)moduleInfoClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        });
    }

    public static String getModuleInfoClassName(String packageName) {
        return packageName + "." + "$YangModuleInfoImpl";
    }

    public static boolean isBindingClass(Class<?> cls) {
        if (DataContainer.class.isAssignableFrom(cls) || Augmentation.class.isAssignableFrom(cls)) {
            return true;
        }
        return cls.getName().startsWith("org.opendaylight.yang.gen.v1");
    }

    public static boolean isNotificationCallback(Method method) {
        Class<?> potentialNotification;
        Preconditions.checkArgument(method != null);
        return method.getName().startsWith("on") && method.getParameterTypes().length == 1 && BindingReflections.isNotification(potentialNotification = method.getParameterTypes()[0]) && method.getName().equals("on" + potentialNotification.getSimpleName());
    }

    public static boolean isNotification(Class<?> potentialNotification) {
        Preconditions.checkArgument(potentialNotification != null, "potentialNotification must not be null.");
        return Notification.class.isAssignableFrom(potentialNotification);
    }

    public static ImmutableSet<YangModuleInfo> loadModuleInfos() {
        return BindingReflections.loadModuleInfos(Thread.currentThread().getContextClassLoader());
    }

    public static ImmutableSet<YangModuleInfo> loadModuleInfos(ClassLoader loader) {
        ImmutableSet.Builder<YangModuleInfo> moduleInfoSet = ImmutableSet.builder();
        ServiceLoader<YangModelBindingProvider> serviceLoader = ServiceLoader.load(YangModelBindingProvider.class, loader);
        for (YangModelBindingProvider bindingProvider : serviceLoader) {
            YangModuleInfo moduleInfo = bindingProvider.getModuleInfo();
            Preconditions.checkState(moduleInfo != null, "Module Info for %s is not available.", bindingProvider.getClass());
            BindingReflections.collectYangModuleInfo(bindingProvider.getModuleInfo(), moduleInfoSet);
        }
        return moduleInfoSet.build();
    }

    private static void collectYangModuleInfo(YangModuleInfo moduleInfo, ImmutableSet.Builder<YangModuleInfo> moduleInfoSet) {
        moduleInfoSet.add((Object)moduleInfo);
        for (YangModuleInfo dependency : moduleInfo.getImportedModules()) {
            BindingReflections.collectYangModuleInfo(dependency, moduleInfoSet);
        }
    }

    public static boolean isRpcType(Class<? extends DataObject> targetType) {
        return DataContainer.class.isAssignableFrom(targetType) && !ChildOf.class.isAssignableFrom(targetType) && !Notification.class.isAssignableFrom(targetType) && (targetType.getName().endsWith("Input") || targetType.getName().endsWith("Output"));
    }

    public static Iterable<Class<? extends DataObject>> getChildrenClasses(Class<? extends DataContainer> type) {
        Preconditions.checkArgument(type != null, "Target type must not be null");
        Preconditions.checkArgument(DataContainer.class.isAssignableFrom(type), "Supplied type must be derived from DataContainer");
        LinkedList<Class<? extends DataObject>> ret = new LinkedList<Class<? extends DataObject>>();
        for (Method method : type.getMethods()) {
            Optional<Class<? extends DataContainer>> entity = BindingReflections.getYangModeledReturnType(method);
            if (!entity.isPresent()) continue;
            ret.add(entity.get());
        }
        return ret;
    }

    public static Map<Class<?>, Method> getChildrenClassToMethod(Class<?> type) {
        Preconditions.checkArgument(type != null, "Target type must not be null");
        Preconditions.checkArgument(DataContainer.class.isAssignableFrom(type), "Supplied type %s must be derived from DataContainer", type);
        HashMap ret = new HashMap();
        for (Method method : type.getMethods()) {
            Optional<Class<? extends DataContainer>> entity = BindingReflections.getYangModeledReturnType(method);
            if (!entity.isPresent()) continue;
            ret.put(entity.get(), method);
        }
        return ret;
    }

    private static Optional<Class<? extends DataContainer>> getYangModeledReturnType(Method method) {
        if ("getClass".equals(method.getName()) || !method.getName().startsWith("get") || method.getParameterTypes().length > 0) {
            return Optional.absent();
        }
        Class<?> returnType = method.getReturnType();
        if (DataContainer.class.isAssignableFrom(returnType)) {
            return Optional.of(returnType);
        }
        if (List.class.isAssignableFrom(returnType)) {
            try {
                return ClassLoaderUtils.callWithClassLoader(method.getDeclaringClass().getClassLoader(), () -> {
                    Type listResult = ClassLoaderUtils.getFirstGenericParameter(method.getGenericReturnType());
                    if (listResult instanceof Class && DataContainer.class.isAssignableFrom((Class)listResult)) {
                        return Optional.of((Class)listResult);
                    }
                    return Optional.absent();
                });
            }
            catch (Exception e) {
                LOG.debug("Unable to find YANG modeled return type for {}", (Object)method, (Object)e);
            }
        }
        return Optional.absent();
    }

    @Deprecated
    public static QName getModuleQName(YangModuleInfo moduleInfo) {
        Preconditions.checkArgument(moduleInfo != null, "moduleInfo must not be null.");
        return moduleInfo.getName();
    }

    public static Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Augmentable<?> input) {
        return AugmentationFieldGetter.getGetter(input.getClass()).getAugmentations(input);
    }

    public static boolean isSubstitutionFor(Class potential, Class target) {
        HashSet<Class<?>> targetImplemented;
        HashSet<Class<?>> subImplemented = Sets.newHashSet(potential.getInterfaces());
        if (!subImplemented.equals(targetImplemented = Sets.newHashSet(target.getInterfaces()))) {
            return false;
        }
        if (Augmentation.class.isAssignableFrom(potential) && !BindingReflections.findAugmentationTarget(potential).equals(BindingReflections.findAugmentationTarget(target))) {
            return false;
        }
        for (Method potentialMethod : potential.getMethods()) {
            try {
                Method targetMethod = target.getMethod(potentialMethod.getName(), potentialMethod.getParameterTypes());
                if (potentialMethod.getReturnType().equals(targetMethod.getReturnType())) continue;
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Could not compare methods", e);
            }
        }
        return true;
    }

    private static class ClassToQNameLoader
    extends CacheLoader<Class<?>, Optional<QName>> {
        private ClassToQNameLoader() {
        }

        @Override
        public Optional<QName> load(Class<?> key) throws Exception {
            return ClassToQNameLoader.resolveQNameNoCache(key);
        }

        private static Optional<QName> resolveQNameNoCache(Class<?> key) {
            try {
                Field field;
                try {
                    field = key.getField("QNAME");
                }
                catch (NoSuchFieldException e) {
                    LOG.debug("{} does not have a {} field, falling back to computation", key, "QNAME", e);
                    return Optional.of(ClassToQNameLoader.computeQName(key));
                }
                Object obj = field.get(null);
                if (obj instanceof QName) {
                    return Optional.of((QName)obj);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.debug("Unexpected exception during extracting QName for {}", (Object)key, (Object)e);
            }
            return Optional.absent();
        }

        private static QName computeQName(Class key) {
            YangModuleInfo moduleInfo;
            Preconditions.checkArgument(BindingReflections.isBindingClass(key), "Supplied class %s is not derived from YANG.", (Object)key);
            try {
                moduleInfo = BindingReflections.getModuleInfo(key);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get QName for " + key + ". YangModuleInfo was not found.", e);
            }
            QName module = moduleInfo.getName();
            if (Augmentation.class.isAssignableFrom(key)) {
                return module;
            }
            if (BindingReflections.isRpcType(key)) {
                String className = key.getSimpleName();
                if (className.endsWith("Output")) {
                    return YangConstants.operationOutputQName(module.getModule()).intern();
                }
                return YangConstants.operationInputQName(module.getModule()).intern();
            }
            return module;
        }
    }
}

