/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfYangUtil;
import org.opendaylight.mdsal.model.ietf.util.Ipv4Utils;

final class Ipv6Utils {
    private static final int INADDR4SZ = 4;
    private static final int INADDR6SZ = 16;
    private static final int INT16SZ = 2;

    private Ipv6Utils() {
        throw new UnsupportedOperationException();
    }

    static void fillIpv6Bytes(@Nonnull byte[] bytes, String str, int strLimit) {
        int i = 0;
        if (str.charAt(i) == ':') {
            Preconditions.checkArgument(str.charAt(++i) == ':', "Invalid v6 address '%s'", (Object)str);
        }
        boolean haveVal = false;
        int val = 0;
        int colonp = -1;
        int j = 0;
        int curtok = i;
        while (i < strLimit) {
            char ch;
            if ((ch = str.charAt(i++)) == ':') {
                curtok = i;
                if (haveVal) {
                    bytes[j++] = (byte)(val >>> 8 & 0xFF);
                    bytes[j++] = (byte)(val & 0xFF);
                    haveVal = false;
                    val = 0;
                    continue;
                }
                colonp = j;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                Ipv4Utils.fillIpv4Bytes(bytes, j, str, curtok, strLimit);
                j += 4;
                haveVal = false;
                break;
            }
            byte chval = AbstractIetfYangUtil.hexValue(ch);
            val = val << 4 | chval;
            haveVal = true;
        }
        if (haveVal) {
            Verify.verify(j + 2 <= 16, "Overrun in parsing of '%s', should not occur", (Object)str);
            bytes[j++] = (byte)(val >> 8 & 0xFF);
            bytes[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            Verify.verify(j != 16, "Overrun in parsing of '%s', should not occur", (Object)str);
            Ipv6Utils.expandZeros(bytes, colonp, j);
        } else {
            Verify.verify(j == 16, "Overrun in parsing of '%s', should not occur", (Object)str);
        }
    }

    private static void expandZeros(byte[] bytes, int where, int filledBytes) {
        int tailLength = filledBytes - where;
        int tailOffset = 16 - tailLength;
        System.arraycopy(bytes, where, bytes, tailOffset, tailLength);
        Arrays.fill(bytes, where, tailOffset, (byte)0);
    }
}

