/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.OperationalStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.error.code.tlv.LspErrorCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.LspBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.PathBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.symbolic.path.name.tlv.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv;

public class Stateful07LspObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    public static final int CLASS = 32;
    public static final int TYPE = 1;
    protected static final int DELEGATE = 11;
    protected static final int SYNC = 10;
    protected static final int REMOVE = 9;
    protected static final int ADMINISTRATIVE = 8;
    protected static final int OPERATIONAL = 5;
    protected static final int FOUR_BITS_SHIFT = 4;
    protected static final int FLAGS_SIZE = 12;

    public Stateful07LspObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public Lsp parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        LspBuilder builder = new LspBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        int[] plspIdRaw = new int[]{bytes.readUnsignedByte(), bytes.readUnsignedByte(), bytes.getUnsignedByte(2)};
        builder.setPlspId(new PlspId(Long.valueOf(plspIdRaw[0] << 12 | plspIdRaw[1] << 4 | plspIdRaw[2] >> 4)));
        this.parseFlags(builder, bytes);
        TlvsBuilder b = new TlvsBuilder();
        this.parseTlvs(b, bytes.slice());
        builder.setTlvs(b.build());
        return builder.build();
    }

    protected void parseFlags(LspBuilder builder, ByteBuf bytes) {
        BitArray flags = BitArray.valueOf(bytes, 12);
        builder.setDelegate(flags.get(11));
        builder.setSync(flags.get(10));
        builder.setRemove(flags.get(9));
        builder.setAdministrative(flags.get(8));
        short s = 0;
        s = (short)(s | (flags.get(7) ? 1 : 0));
        s = (short)(s | (flags.get(6) ? 1 : 0) << 1);
        s = (short)(s | (flags.get(5) ? 1 : 0) << 2);
        builder.setOperational(OperationalStatus.forValue(s));
    }

    @Override
    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof LspErrorCode) {
            builder.setLspErrorCode((LspErrorCode)tlv);
        } else if (tlv instanceof LspIdentifiers) {
            builder.setLspIdentifiers((LspIdentifiers)tlv);
        } else if (tlv instanceof RsvpErrorSpec) {
            builder.setRsvpErrorSpec((RsvpErrorSpec)tlv);
        } else if (tlv instanceof SymbolicPathName) {
            builder.setSymbolicPathName((SymbolicPathName)tlv);
        } else if (tlv instanceof VsTlv) {
            builder.setVsTlv((VsTlv)tlv);
        } else if (tlv instanceof PathBinding) {
            builder.setPathBinding((PathBinding)tlv);
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Lsp, "Wrong instance of PCEPObject. Passed %s . Needed LspObject.", object.getClass());
        Lsp specObj = (Lsp)object;
        ByteBuf body = Unpooled.buffer();
        Preconditions.checkArgument(specObj.getPlspId() != null, "PLSP-ID not present");
        ByteBufWriteUtil.writeMedium(specObj.getPlspId().getValue().intValue() << 4, body);
        BitArray flags = this.serializeFlags(specObj);
        byte op = 0;
        if (specObj.getOperational() != null) {
            op = UnsignedBytes.checkedCast(specObj.getOperational().getIntValue());
            op = (byte)(op << 4);
        }
        byte[] res = flags.array();
        res[res.length - 1] = (byte)(res[res.length - 1] | op);
        body.writeByte(res[res.length - 1]);
        this.serializeTlvs(specObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 32, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    protected BitArray serializeFlags(Lsp specObj) {
        BitArray flags = new BitArray(12);
        flags.set(11, specObj.isDelegate());
        flags.set(9, specObj.isRemove());
        flags.set(10, specObj.isSync());
        flags.set(8, specObj.isAdministrative());
        return flags;
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getLspErrorCode() != null) {
            this.serializeTlv(tlvs.getLspErrorCode(), body);
        }
        if (tlvs.getLspIdentifiers() != null) {
            this.serializeTlv(tlvs.getLspIdentifiers(), body);
        }
        if (tlvs.getRsvpErrorSpec() != null) {
            this.serializeTlv(tlvs.getRsvpErrorSpec(), body);
        }
        if (tlvs.getSymbolicPathName() != null) {
            this.serializeTlv(tlvs.getSymbolicPathName(), body);
        }
        if (tlvs.getVsTlv() != null) {
            this.serializeTlv(tlvs.getVsTlv(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        if (tlvs.getPathBinding() != null) {
            this.serializeTlv(tlvs.getPathBinding(), body);
        }
    }

    @Override
    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

