/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.Pcupd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PcupdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.PcupdMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.UpdatesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.updates.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.updates.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidth;

public class Stateful07PCUpdateRequestMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 11;

    public Stateful07PCUpdateRequestMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof Pcupd, "Wrong instance of Message. Passed instance of %s. Need Pcupd.", message.getClass());
        Pcupd msg = (Pcupd)message;
        List<Updates> updates = msg.getPcupdMessage().getUpdates();
        ByteBuf buffer = Unpooled.buffer();
        for (Updates update : updates) {
            this.serializeUpdate(update, buffer);
        }
        MessageUtil.formatMessage(11, buffer, out);
    }

    protected void serializeUpdate(Updates update, ByteBuf buffer) {
        this.serializeObject(update.getSrp(), buffer);
        this.serializeObject(update.getLsp(), buffer);
        Path p = update.getPath();
        if (p != null) {
            this.serializeObject(p.getEro(), buffer);
            this.serializeObject(p.getLspa(), buffer);
            this.serializeObject(p.getBandwidth(), buffer);
            this.serializeObject(p.getReoptimizationBandwidth(), buffer);
            if (p.getMetrics() != null) {
                for (Metrics m : p.getMetrics()) {
                    this.serializeObject(m.getMetric(), buffer);
                }
            }
            this.serializeObject(p.getIro(), buffer);
        }
    }

    @Override
    protected Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcup message cannot be empty.");
        }
        ArrayList<Updates> updateRequests = Lists.newArrayList();
        while (!objects.isEmpty()) {
            Updates upd = this.getValidUpdates(objects, errors);
            if (upd == null) continue;
            updateRequests.add(upd);
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcupdBuilder().setPcupdMessage(new PcupdMessageBuilder().setUpdates(updateRequests).build()).build();
    }

    protected Updates getValidUpdates(List<Object> objects, List<Message> errors) {
        UpdatesBuilder builder = new UpdatesBuilder();
        Object object = objects.remove(0);
        if (object instanceof Srp) {
            builder.setSrp((Srp)object);
            object = objects.isEmpty() ? null : objects.remove(0);
        } else {
            errors.add(Stateful07PCUpdateRequestMessageParser.createErrorMsg(PCEPErrors.SRP_MISSING, Optional.absent()));
        }
        if (Stateful07PCUpdateRequestMessageParser.validateLsp(object, errors, builder)) {
            if (!objects.isEmpty() && !Stateful07PCUpdateRequestMessageParser.validatePath(objects, errors, builder)) {
                return null;
            }
            return builder.build();
        }
        return null;
    }

    private static boolean validateLsp(Object object, List<Message> errors, UpdatesBuilder builder) {
        if (!(object instanceof Lsp)) {
            errors.add(Stateful07PCUpdateRequestMessageParser.createErrorMsg(PCEPErrors.LSP_MISSING, Optional.absent()));
            return false;
        }
        builder.setLsp((Lsp)object);
        return true;
    }

    private static boolean validatePath(List<Object> objects, List<Message> errors, UpdatesBuilder builder) {
        PathBuilder pBuilder = new PathBuilder();
        Object object = objects.remove(0);
        if (!(object instanceof Ero)) {
            errors.add(Stateful07PCUpdateRequestMessageParser.createErrorMsg(PCEPErrors.ERO_MISSING, Optional.absent()));
            return false;
        }
        pBuilder.setEro((Ero)object);
        Stateful07PCUpdateRequestMessageParser.parsePath(objects, pBuilder);
        builder.setPath(pBuilder.build());
        return true;
    }

    private static void parsePath(List<Object> objects, PathBuilder pBuilder) {
        ArrayList<Metrics> pathMetrics = Lists.newArrayList();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            Object obj = objects.get(0);
            if ((state = Stateful07PCUpdateRequestMessageParser.insertObject(state, obj, pBuilder, pathMetrics)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            pBuilder.setMetrics(pathMetrics);
        }
    }

    private static State insertObject(State state, Object obj, PathBuilder pBuilder, List<Metrics> pathMetrics) {
        switch (state) {
            case INIT: {
                if (obj instanceof Lspa) {
                    pBuilder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Bandwidth) {
                    pBuilder.setBandwidth((Bandwidth)obj);
                    return State.LSPA_IN;
                }
                if (obj instanceof ReoptimizationBandwidth) {
                    pBuilder.setReoptimizationBandwidth((ReoptimizationBandwidth)obj);
                    return State.LSPA_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    pBuilder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        END;

    }
}

