/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.stateful.capability.tlv.StatefulBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

public class Stateful07StatefulCapabilityTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 16;
    protected static final int FLAGS_F_LENGTH = 32;
    protected static final int U_FLAG_OFFSET = 31;

    @Override
    public Stateful parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        if (buffer.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >= " + 4 + ".");
        }
        StatefulBuilder sb = new StatefulBuilder();
        this.parseFlags(sb, buffer);
        return sb.build();
    }

    protected void parseFlags(StatefulBuilder sb, ByteBuf buffer) {
        BitArray flags = BitArray.valueOf(buffer, 32);
        sb.setLspUpdateCapability(flags.get(31));
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof Stateful, "StatefulCapabilityTlv is mandatory.");
        Stateful sct = (Stateful)tlv;
        TlvUtil.formatTlv(16, Unpooled.wrappedBuffer(this.serializeFlags(sct).array()), buffer);
    }

    protected BitArray serializeFlags(Stateful sct) {
        BitArray flags = new BitArray(32);
        flags.set(31, sct.isLspUpdateCapability());
        return flags;
    }
}

