/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;

public final class DefaultPCEPSessionNegotiator
extends AbstractPCEPSessionNegotiator {
    private final PCEPSessionListener listener;
    private final int maxUnknownMessages;
    private final Open myLocalPrefs;

    public DefaultPCEPSessionNegotiator(Promise<PCEPSessionImpl> promise, Channel channel, PCEPSessionListener listener, short sessionId, int maxUnknownMessages, Open localPrefs, Tls tlsConfiguration) {
        super(promise, channel);
        super.setTlsConfiguration(tlsConfiguration);
        this.maxUnknownMessages = maxUnknownMessages;
        this.myLocalPrefs = new OpenBuilder().setKeepalive(localPrefs.getKeepalive()).setDeadTimer(localPrefs.getDeadTimer()).setSessionId(sessionId).setTlvs(localPrefs.getTlvs()).build();
        this.listener = Objects.requireNonNull(listener);
    }

    public DefaultPCEPSessionNegotiator(Promise<PCEPSessionImpl> promise, Channel channel, PCEPSessionListener listener, short sessionId, int maxUnknownMessages, Open localPrefs) {
        this(promise, channel, listener, sessionId, maxUnknownMessages, localPrefs, null);
    }

    @Override
    protected Open getInitialProposal() {
        return this.myLocalPrefs;
    }

    @Override
    @VisibleForTesting
    public PCEPSessionImpl createSession(Channel channel, Open localPrefs, Open remotePrefs) {
        return new PCEPSessionImpl(this.listener, this.maxUnknownMessages, channel, localPrefs, remotePrefs);
    }

    @Override
    protected boolean isProposalAcceptable(Open open) {
        return true;
    }

    @Override
    protected Open getCounterProposal(Open open) {
        return null;
    }

    @Override
    protected Open getRevisedProposal(Open suggestion) {
        return this.myLocalPrefs;
    }
}

