/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.opendaylight.protocol.util.StatisticsUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessagesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastReceivedErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastSentErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.MessagesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;

final class PCEPSessionState {
    private final Open localOpen;
    private long sentMsgCount = 0L;
    private long receivedMsgCount = 0L;
    private long sentErrMsgCount = 0L;
    private long receivedErrMsgCount = 0L;
    private long lastSentMsgTimestamp = 0L;
    private final PeerPref peerPref;
    private final LocalPref localPref;
    private final LastReceivedErrorBuilder lastReceivedErrorBuilder;
    private final LastSentErrorBuilder lastSentErrorBuilder;
    private final ErrorMessagesBuilder errorsBuilder;
    private final MessagesBuilder msgsBuilder;

    PCEPSessionState(Open remoteOpen, Open localOpen, Channel channel) {
        Objects.requireNonNull(remoteOpen);
        Objects.requireNonNull(localOpen);
        Objects.requireNonNull(channel);
        this.localOpen = localOpen;
        this.peerPref = PCEPSessionState.getRemotePref(remoteOpen, channel);
        this.localPref = PCEPSessionState.getLocalPref(localOpen, channel);
        this.lastReceivedErrorBuilder = new LastReceivedErrorBuilder();
        this.lastSentErrorBuilder = new LastSentErrorBuilder();
        this.errorsBuilder = new ErrorMessagesBuilder();
        this.msgsBuilder = new MessagesBuilder();
    }

    Messages getMessages(int unknownMessagesCount) {
        this.errorsBuilder.setReceivedErrorMsgCount(this.receivedErrMsgCount);
        this.errorsBuilder.setSentErrorMsgCount(this.sentErrMsgCount);
        this.errorsBuilder.setLastReceivedError(this.lastReceivedErrorBuilder.build());
        this.errorsBuilder.setLastSentError(this.lastSentErrorBuilder.build());
        this.msgsBuilder.setLastSentMsgTimestamp(this.lastSentMsgTimestamp);
        this.msgsBuilder.setReceivedMsgCount(this.receivedMsgCount);
        this.msgsBuilder.setSentMsgCount(this.sentMsgCount);
        this.msgsBuilder.setUnknownMsgReceived(unknownMessagesCount);
        this.msgsBuilder.setErrorMessages(this.errorsBuilder.build());
        return this.msgsBuilder.build();
    }

    public LocalPref getLocalPref() {
        return this.localPref;
    }

    PeerPref getPeerPref() {
        return this.peerPref;
    }

    void setLastSentError(Message msg) {
        ++this.sentErrMsgCount;
        ErrorObject errObj = PCEPSessionState.getErrorObject(msg);
        this.lastSentErrorBuilder.setErrorType(errObj.getType());
        this.lastSentErrorBuilder.setErrorValue(errObj.getValue());
    }

    void setLastReceivedError(Message msg) {
        ErrorObject errObj = PCEPSessionState.getErrorObject(msg);
        ++this.receivedErrMsgCount;
        this.lastReceivedErrorBuilder.setErrorType(errObj.getType());
        this.lastReceivedErrorBuilder.setErrorValue(errObj.getValue());
    }

    void updateLastReceivedMsg() {
        ++this.receivedMsgCount;
    }

    void updateLastSentMsg() {
        this.lastSentMsgTimestamp = StatisticsUtil.getCurrentTimestampInSeconds();
        ++this.sentMsgCount;
    }

    private static ErrorObject getErrorObject(Message msg) {
        Objects.requireNonNull(msg);
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessage errMsg = ((PcerrMessage)msg).getPcerrMessage();
        return errMsg.getErrors().get(errMsg.getErrors().size() - 1).getErrorObject();
    }

    private static PeerPref getRemotePref(Open open, Channel channel) {
        PeerPrefBuilder peerBuilder = new PeerPrefBuilder();
        peerBuilder.setDeadtimer(open.getDeadTimer());
        peerBuilder.setKeepalive(open.getKeepalive());
        peerBuilder.setIpAddress(((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress());
        peerBuilder.setSessionId(open.getSessionId().intValue());
        return peerBuilder.build();
    }

    private static LocalPref getLocalPref(Open open, Channel channel) {
        LocalPrefBuilder peerBuilder = new LocalPrefBuilder();
        peerBuilder.setDeadtimer(open.getDeadTimer());
        peerBuilder.setKeepalive(open.getKeepalive());
        peerBuilder.setIpAddress(((InetSocketAddress)channel.localAddress()).getAddress().getHostAddress());
        peerBuilder.setSessionId(open.getSessionId().intValue());
        return peerBuilder.build();
    }

    public Open getLocalOpen() {
        return this.localOpen;
    }
}

