/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.SessionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.SessionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.session._case.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;

public class PCEPErrorMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 6;

    public PCEPErrorMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage, "Wrong instance of Message. Passed instance of %s. Need PcerrMessage.", message.getClass());
        PcerrMessage err = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage)message).getPcerrMessage();
        Preconditions.checkArgument(err.getErrors() != null && !err.getErrors().isEmpty(), "Errors should not be empty.");
        ByteBuf buffer = Unpooled.buffer();
        this.serializeCases(err, buffer);
        for (Errors e : err.getErrors()) {
            this.serializeObject(e.getErrorObject(), buffer);
        }
        if (err.getErrorType() instanceof SessionCase) {
            this.serializeObject(((SessionCase)err.getErrorType()).getSession().getOpen(), buffer);
        }
        MessageUtil.formatMessage(6, buffer, out);
    }

    protected void serializeCases(PcerrMessage err, ByteBuf buffer) {
        if (err.getErrorType() instanceof RequestCase) {
            List<Rps> rps = ((RequestCase)err.getErrorType()).getRequest().getRps();
            for (Rps r : rps) {
                this.serializeObject(r.getRp(), buffer);
            }
        }
    }

    @Override
    protected org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Object o;
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Error message is empty.");
        }
        ArrayList<Rps> requestParameters = new ArrayList<Rps>();
        ArrayList<Errors> errorObjects = new ArrayList<Errors>();
        PcerrMessageBuilder b = new PcerrMessageBuilder();
        Object obj = objects.get(0);
        State state = State.INIT;
        if (obj instanceof ErrorObject) {
            o = (ErrorObject)obj;
            errorObjects.add(new ErrorsBuilder().setErrorObject((ErrorObject)o).build());
            state = State.ERROR_IN;
        } else if (obj instanceof Rp) {
            o = (Rp)obj;
            if (o.isProcessingRule().booleanValue()) {
                errors.add(PCEPErrorMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.absent()));
                return null;
            }
            requestParameters.add(new RpsBuilder().setRp((Rp)o).build());
            state = State.RP_IN;
        }
        if (state.equals((java.lang.Object)State.INIT)) {
            throw new PCEPDeserializerException("At least one PCEPErrorObject is mandatory.");
        }
        objects.remove(0);
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            obj = objects.get(0);
            if (obj instanceof UnknownObject) {
                return new PcerrBuilder().setPcerrMessage(b.setErrors(((UnknownObject)obj).getErrors()).build()).build();
            }
            if ((state = PCEPErrorMessageParser.insertObject(state, errorObjects, obj, requestParameters, b)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (errorObjects.isEmpty()) {
            throw new PCEPDeserializerException("At least one PCEPErrorObject is mandatory.");
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        if (!requestParameters.isEmpty()) {
            b.setErrorType(new RequestCaseBuilder().setRequest(new RequestBuilder().setRps(requestParameters).build()).build());
        }
        return new PcerrBuilder().setPcerrMessage(b.setErrors(errorObjects).build()).build();
    }

    private static State insertObject(State state, List<Errors> errorObjects, Object obj, List<Rps> requestParameters, PcerrMessageBuilder b) {
        switch (state) {
            case RP_IN: {
                if (obj instanceof Rp) {
                    Rp o = (Rp)obj;
                    requestParameters.add(new RpsBuilder().setRp(o).build());
                    return State.RP_IN;
                }
            }
            case ERROR_IN: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR_IN;
                }
            }
            case OPEN: {
                if (obj instanceof Open) {
                    b.setErrorType(new SessionCaseBuilder().setSession(new SessionBuilder().setOpen((Open)obj).build()).build());
                    return State.OPEN_IN;
                }
            }
            case ERROR: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR;
                }
            }
            case OPEN_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        ERROR_IN,
        RP_IN,
        OPEN,
        ERROR,
        OPEN_IN,
        END;

    }
}

