/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.parser.util.Util;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcrep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.PcrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.PcrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.RepliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.FailureCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.SuccessCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.SuccessCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.SuccessBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.PathsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;

public class PCEPReplyMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 4;

    public PCEPReplyMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof Pcrep, "Wrong instance of Message. Passed instance of %s. Need Pcrep.", message.getClass());
        PcrepMessage repMsg = ((Pcrep)message).getPcrepMessage();
        Preconditions.checkArgument(repMsg.getReplies() != null && !repMsg.getReplies().isEmpty(), "Replies cannot be null or empty.");
        ByteBuf buffer = Unpooled.buffer();
        for (Replies reply : repMsg.getReplies()) {
            Preconditions.checkArgument(reply.getRp() != null, "Reply must contain RP object.");
            this.serializeReply(reply, buffer);
        }
        MessageUtil.formatMessage(4, buffer, out);
    }

    protected void serializeReply(Replies reply, ByteBuf buffer) {
        this.serializeObject(reply.getRp(), buffer);
        this.serializeMonitoring(reply, buffer);
        this.serializeVendorInformationObjects(reply.getVendorInformationObject(), buffer);
        if (reply.getResult() == null) {
            return;
        }
        if (reply.getResult() instanceof FailureCase) {
            FailureCase f = (FailureCase)reply.getResult();
            this.serializeFailure(f, buffer);
            return;
        }
        SuccessCase s = (SuccessCase)reply.getResult();
        this.serializeSuccess(s, buffer);
        this.serializeMonitoringMetrics(reply, buffer);
    }

    private void serializeFailure(FailureCase f, ByteBuf buffer) {
        if (f == null) {
            return;
        }
        this.serializeObject(f.getNoPath(), buffer);
        this.serializeObject(f.getLspa(), buffer);
        this.serializeObject(f.getBandwidth(), buffer);
        if (f.getMetrics() != null) {
            for (Metrics m : f.getMetrics()) {
                this.serializeObject(m.getMetric(), buffer);
            }
        }
        this.serializeObject(f.getIro(), buffer);
    }

    private void serializeSuccess(SuccessCase s, ByteBuf buffer) {
        if (s == null || s.getSuccess() == null) {
            return;
        }
        for (Paths p : s.getSuccess().getPaths()) {
            this.serializeObject(p.getEro(), buffer);
            this.serializeObject(p.getLspa(), buffer);
            this.serializeObject(p.getOf(), buffer);
            this.serializeObject(p.getBandwidth(), buffer);
            if (p.getMetrics() != null) {
                for (Metrics m : p.getMetrics()) {
                    this.serializeObject(m.getMetric(), buffer);
                }
            }
            this.serializeObject(p.getIro(), buffer);
        }
        this.serializeVendorInformationObjects(s.getSuccess().getVendorInformationObject(), buffer);
    }

    private void serializeMonitoring(Replies reply, ByteBuf buffer) {
        this.serializeObject(reply.getMonitoring(), buffer);
        this.serializeObject(reply.getPccIdReq(), buffer);
    }

    private void serializeMonitoringMetrics(Replies reply, ByteBuf buffer) {
        if (reply.getMetricPce() != null) {
            for (MetricPce metricPce : reply.getMetricPce()) {
                this.serializeMetricPce(metricPce, buffer);
            }
        }
    }

    protected void serializeMetricPce(MetricPce metricPce, ByteBuf buffer) {
        Preconditions.checkArgument(metricPce.getPceId() != null, "PCE-ID must be present.");
        this.serializeObject(metricPce.getPceId(), buffer);
        this.serializeObject(metricPce.getProcTime(), buffer);
        this.serializeObject(metricPce.getOverload(), buffer);
    }

    @Override
    protected Pcrep validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrep message cannot be empty.");
        }
        ArrayList<Replies> replies = new ArrayList<Replies>();
        while (!objects.isEmpty()) {
            Replies r = this.getValidReply(objects, errors);
            if (r == null) continue;
            replies.add(r);
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().setReplies(replies).build()).build();
    }

    protected Replies getValidReply(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Object object = objects.remove(0);
        if (!(object instanceof Rp)) {
            errors.add(PCEPReplyMessageParser.createErrorMsg(PCEPErrors.RP_MISSING, Optional.absent()));
            return null;
        }
        Rp rp = (Rp)object;
        RepliesBuilder repliesBuilder = new RepliesBuilder();
        if (!objects.isEmpty() && objects.get(0) instanceof Monitoring) {
            repliesBuilder.setMonitoring((Monitoring)objects.get(0));
            objects.remove(0);
        }
        if (!objects.isEmpty() && objects.get(0) instanceof PccIdReq) {
            repliesBuilder.setPccIdReq((PccIdReq)objects.get(0));
            objects.remove(0);
        }
        List<VendorInformationObject> vendorInfo = PCEPReplyMessageParser.addVendorInformationObjects(objects);
        Result res = null;
        if (!objects.isEmpty()) {
            if (objects.get(0) instanceof NoPath) {
                res = this.handleNoPath((NoPath)objects.get(0), objects);
            } else if (objects.get(0) instanceof Ero) {
                res = this.handleEro((Ero)objects.get(0), objects);
            }
        }
        ArrayList<MetricPce> metricPceList = new ArrayList<MetricPce>();
        if (!objects.isEmpty() && objects.get(0) instanceof PceId) {
            while (!objects.isEmpty()) {
                metricPceList.add(Util.validateMonitoringMetrics(objects));
            }
        }
        if (!vendorInfo.isEmpty()) {
            repliesBuilder.setVendorInformationObject(vendorInfo);
        }
        if (!metricPceList.isEmpty()) {
            repliesBuilder.setMetricPce(metricPceList);
        }
        return repliesBuilder.setRp(rp).setResult(res).build();
    }

    private Result handleNoPath(NoPath noPath, List<Object> objects) {
        objects.remove(0);
        FailureCaseBuilder builder = new FailureCaseBuilder();
        builder.setNoPath(noPath);
        while (!objects.isEmpty() && !(objects.get(0) instanceof PceId)) {
            this.parseAttributes(builder, objects);
        }
        return builder.build();
    }

    private Result handleEro(Ero ero, List<Object> objects) {
        objects.remove(0);
        SuccessBuilder builder = new SuccessBuilder();
        ArrayList<Paths> paths = new ArrayList<Paths>();
        PathsBuilder pBuilder = new PathsBuilder();
        pBuilder.setEro(ero);
        while (!objects.isEmpty() && !(objects.get(0) instanceof PceId)) {
            List<VendorInformationObject> vendorInfoObjects = PCEPReplyMessageParser.addVendorInformationObjects(objects);
            if (!vendorInfoObjects.isEmpty()) {
                builder.setVendorInformationObject(vendorInfoObjects);
            }
            this.parsePath(pBuilder, objects);
            paths.add(pBuilder.build());
        }
        builder.setPaths(paths);
        return new SuccessCaseBuilder().setSuccess(builder.build()).build();
    }

    protected void parseAttributes(FailureCaseBuilder builder, List<Object> objects) {
        ArrayList<Metrics> pathMetrics = new ArrayList<Metrics>();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            Object obj = objects.get(0);
            if ((state = PCEPReplyMessageParser.insertObject(state, obj, builder, pathMetrics)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static State insertObject(State state, Object obj, FailureCaseBuilder builder, List<Metrics> pathMetrics) {
        switch (state) {
            case INIT: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    protected void parsePath(PathsBuilder builder, List<Object> objects) {
        ArrayList<Metrics> pathMetrics = new ArrayList<Metrics>();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            Object obj = objects.get(0);
            if ((state = PCEPReplyMessageParser.insertObject(state, obj, builder, pathMetrics)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static State insertObject(State state, Object obj, PathsBuilder builder, List<Metrics> pathMetrics) {
        switch (state) {
            case INIT: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return State.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        LSPA_IN,
        OF_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        END;

    }
}

