/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.MonitoringRequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.monitoring.request.PceIdListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.PathKeyExpansionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;

public class PCEPRequestMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 3;

    public PCEPRequestMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof Pcreq, "Wrong instance of Message. Passed instance of %s. Need Pcreq.", message.getClass());
        PcreqMessage msg = ((Pcreq)message).getPcreqMessage();
        Preconditions.checkArgument(msg.getRequests() != null && !msg.getRequests().isEmpty(), "Requests cannot be null or empty.");
        ByteBuf buffer = Unpooled.buffer();
        if (msg.getMonitoringRequest() != null) {
            this.serializeMonitoringRequest(msg.getMonitoringRequest(), buffer);
        }
        if (msg.getSvec() != null) {
            this.serializeSvec(msg, buffer);
        }
        this.serializeRequest(msg, buffer);
        MessageUtil.formatMessage(3, buffer, out);
    }

    protected void serializeRequest(PcreqMessage msg, ByteBuf buffer) {
        for (Requests req : msg.getRequests()) {
            SegmentComputation sc;
            this.serializeObject(req.getRp(), buffer);
            this.serializeVendorInformationObjects(req.getVendorInformationObject(), buffer);
            if (req.getPathKeyExpansion() != null) {
                this.serializeObject(req.getPathKeyExpansion().getPathKey(), buffer);
            }
            if (req.getSegmentComputation() == null || (sc = req.getSegmentComputation()).getP2p() == null) continue;
            this.serializeP2P(buffer, sc.getP2p());
        }
    }

    protected void serializeSvec(PcreqMessage msg, ByteBuf buffer) {
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec s : msg.getSvec()) {
            this.serializeObject(s.getSvec(), buffer);
            this.serializeObject(s.getOf(), buffer);
            this.serializeObject(s.getGc(), buffer);
            this.serializeObject(s.getXro(), buffer);
            if (s.getMetric() != null) {
                for (Metric m : s.getMetric()) {
                    this.serializeObject(m.getMetric(), buffer);
                }
            }
            this.serializeVendorInformationObjects(s.getVendorInformationObject(), buffer);
        }
    }

    protected void serializeP2P(ByteBuf buffer, P2p p2p) {
        ReportedRoute rr;
        this.serializeObject(p2p.getEndpointsObj(), buffer);
        this.serializeVendorInformationObjects(p2p.getVendorInformationObject(), buffer);
        if (p2p.getReportedRoute() != null && (rr = p2p.getReportedRoute()) != null) {
            this.serializeObject(rr.getRro(), buffer);
            this.serializeObject(rr.getReoptimizationBandwidth(), buffer);
        }
        this.serializeObject(p2p.getLoadBalancing(), buffer);
        this.serializeObject(p2p.getLspa(), buffer);
        this.serializeObject(p2p.getBandwidth(), buffer);
        if (p2p.getMetrics() != null) {
            for (Metrics m : p2p.getMetrics()) {
                this.serializeObject(m.getMetric(), buffer);
            }
        }
        this.serializeObject(p2p.getIro(), buffer);
        this.serializeObject(p2p.getRro(), buffer);
        this.serializeObject(p2p.getXro(), buffer);
        this.serializeObject(p2p.getOf(), buffer);
        this.serializeObject(p2p.getClassType(), buffer);
    }

    protected void serializeMonitoringRequest(MonitoringRequest monReq, ByteBuf out) {
        this.serializeObject(monReq.getMonitoring(), out);
        this.serializeObject(monReq.getPccIdReq(), out);
        if (monReq.getPceIdList() != null) {
            for (PceIdList pceId : monReq.getPceIdList()) {
                this.serializeObject(pceId.getPceId(), out);
            }
        }
    }

    @Override
    protected Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        List<Requests> requests;
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrep message cannot be empty.");
        }
        PcreqMessageBuilder mBuilder = new PcreqMessageBuilder();
        mBuilder.setMonitoringRequest(this.getMonitoring(objects));
        List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec> svecs = this.getSvecs(objects);
        if (!svecs.isEmpty()) {
            mBuilder.setSvec(svecs);
        }
        if ((requests = this.getRequests(objects, errors)) != null) {
            mBuilder.setRequests(requests);
        } else {
            errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.RP_MISSING, Optional.absent()));
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcreqBuilder().setPcreqMessage(mBuilder.build()).build();
    }

    protected List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec> getSvecs(List<Object> objects) {
        SvecBuilder sBuilder;
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec svecComp;
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec> svecList = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec>();
        while (!objects.isEmpty() && (svecComp = PCEPRequestMessageParser.getValidSvec(sBuilder = new SvecBuilder(), objects)) != null) {
            svecList.add(svecComp);
        }
        return svecList;
    }

    protected List<Requests> getRequests(List<Object> objects, List<Message> errors) {
        ArrayList<Requests> requests = new ArrayList<Requests>();
        while (!objects.isEmpty()) {
            SegmentComputation segm;
            RequestsBuilder rBuilder = new RequestsBuilder();
            Rp rpObj = null;
            if (!(objects.get(0) instanceof Rp)) {
                errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.RP_MISSING, Optional.absent()));
                return null;
            }
            rpObj = (Rp)objects.get(0);
            objects.remove(0);
            if (!rpObj.isProcessingRule().booleanValue()) {
                errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.absent()));
            } else {
                rBuilder.setRp(rpObj);
            }
            List<VendorInformationObject> vendorInfo = PCEPRequestMessageParser.addVendorInformationObjects(objects);
            if (!vendorInfo.isEmpty()) {
                rBuilder.setVendorInformationObject(vendorInfo);
            }
            if (rpObj.isPathKey().booleanValue() && objects.get(0) instanceof PathKey) {
                rBuilder.setPathKeyExpansion(new PathKeyExpansionBuilder().setPathKey((PathKey)objects.get(0)).build());
            }
            P2pBuilder p2pBuilder = new P2pBuilder();
            if (!objects.isEmpty() && objects.get(0) instanceof EndpointsObj) {
                EndpointsObj ep = (EndpointsObj)objects.get(0);
                objects.remove(0);
                if (!ep.isProcessingRule().booleanValue()) {
                    errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.of(rpObj)));
                } else {
                    p2pBuilder.setEndpointsObj(ep);
                }
            } else {
                errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.END_POINTS_MISSING, Optional.of(rpObj)));
                return null;
            }
            if (!rpObj.isP2mp().booleanValue() && (segm = this.getSegmentComputation(p2pBuilder, objects, errors, rpObj)) != null) {
                rBuilder.setSegmentComputation(segm);
            }
            requests.add(rBuilder.build());
        }
        return requests;
    }

    protected SegmentComputation getSegmentComputation(P2pBuilder builder, List<Object> objects, List<Message> errors, Rp rp) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        ArrayList<VendorInformationObject> viObjects = new ArrayList<VendorInformationObject>();
        State state = State.INIT;
        while (!objects.isEmpty() && state != State.END) {
            if ((state = PCEPRequestMessageParser.insertObject(state, objects, viObjects, builder, metrics, errors, rp)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (!metrics.isEmpty()) {
            builder.setMetrics(metrics);
        }
        if (!viObjects.isEmpty()) {
            builder.setVendorInformationObject(viObjects);
        }
        if (rp.isReoptimization().booleanValue() && builder.getBandwidth() != null && !builder.getReportedRoute().getReoptimizationBandwidth().getBandwidth().equals(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth(new byte[]{0})) && builder.getReportedRoute().getRro() == null) {
            errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.RRO_MISSING, Optional.of(rp)));
            return null;
        }
        return new SegmentComputationBuilder().setP2p(builder.build()).build();
    }

    private static State insertObject(State state, List<Object> objects, List<VendorInformationObject> viObjects, P2pBuilder builder, List<Metrics> metrics, List<Message> errors, Rp rp) {
        Object obj = objects.get(0);
        switch (state) {
            case INIT: {
                if (obj instanceof Rro) {
                    builder.setRro((Rro)obj);
                    objects.remove(0);
                    Object nextObj = objects.get(0);
                    if (nextObj instanceof ReoptimizationBandwidth) {
                        builder.setReoptimizationBandwidth((ReoptimizationBandwidth)nextObj);
                    }
                    return State.REPORTED_IN;
                }
            }
            case REPORTED_IN: {
                if (obj instanceof VendorInformationObject) {
                    viObjects.add((VendorInformationObject)obj);
                    return State.REPORTED_IN;
                }
            }
            case VENDOR_INFO_LIST: {
                if (obj instanceof LoadBalancing) {
                    builder.setLoadBalancing((LoadBalancing)obj);
                    return State.LOAD_BIN;
                }
            }
            case LOAD_BIN: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric) {
                    metrics.add(new MetricsBuilder().setMetric((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: {
                if (obj instanceof Rro) {
                    builder.setRro((Rro)obj);
                    return State.RRO_IN;
                }
            }
            case RRO_IN: {
                if (obj instanceof Xro) {
                    builder.setXro((Xro)obj);
                    return State.XRO_IN;
                }
            }
            case XRO_IN: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return State.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof ClassType) {
                    ClassType classType = (ClassType)obj;
                    if (!classType.isProcessingRule().booleanValue()) {
                        errors.add(PCEPRequestMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.of(rp)));
                    } else {
                        builder.setClassType(classType);
                    }
                    return State.CT_IN;
                }
            }
            case CT_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec getValidSvec(SvecBuilder builder, List<Object> objects) {
        Preconditions.checkArgument(objects != null && !objects.isEmpty(), "Passed list can't be null or empty.");
        if (!(objects.get(0) instanceof Svec)) {
            return null;
        }
        builder.setSvec((Svec)objects.get(0));
        objects.remove(0);
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        ArrayList<VendorInformationObject> viObjects = new ArrayList<VendorInformationObject>();
        Object obj = null;
        SvecState state = SvecState.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)SvecState.END)) {
            obj = objects.get(0);
            if ((state = PCEPRequestMessageParser.insertObject(state, obj, builder, metrics, viObjects)).equals((java.lang.Object)SvecState.END)) continue;
            objects.remove(0);
        }
        if (!viObjects.isEmpty()) {
            builder.setVendorInformationObject(viObjects);
        }
        return builder.build();
    }

    private static SvecState insertObject(SvecState state, Object obj, SvecBuilder builder, List<Metrics> metrics, List<VendorInformationObject> viObjects) {
        switch (state) {
            case INIT: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return SvecState.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof Gc) {
                    builder.setGc((Gc)obj);
                    return SvecState.GC_IN;
                }
            }
            case GC_IN: {
                if (obj instanceof Xro) {
                    builder.setXro((Xro)obj);
                    return SvecState.XRO_IN;
                }
            }
            case XRO_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric) {
                    metrics.add(new MetricsBuilder().setMetric((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric)obj).build());
                    return SvecState.XRO_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof VendorInformationObject) {
                    viObjects.add((VendorInformationObject)obj);
                    return SvecState.METRIC_IN;
                }
            }
            case VENDOR_INFO: 
            case END: {
                return SvecState.END;
            }
        }
        return state;
    }

    protected MonitoringRequest getMonitoring(List<Object> objects) {
        MonitoringRequestBuilder builder = new MonitoringRequestBuilder();
        if (objects.isEmpty() || !(objects.get(0) instanceof Monitoring)) {
            return null;
        }
        builder.setMonitoring((Monitoring)objects.get(0));
        objects.remove(0);
        if (!objects.isEmpty() && objects.get(0) instanceof PccIdReq) {
            builder.setPccIdReq((PccIdReq)objects.get(0));
            objects.remove(0);
        }
        ArrayList<PceIdList> pceIdList = new ArrayList<PceIdList>();
        while (!objects.isEmpty() && objects.get(0) instanceof PceId) {
            pceIdList.add(new PceIdListBuilder().setPceId((PceId)objects.get(0)).build());
            objects.remove(0);
        }
        if (!pceIdList.isEmpty()) {
            builder.setPceIdList(pceIdList);
        }
        return builder.build();
    }

    private static enum SvecState {
        INIT,
        OF_IN,
        GC_IN,
        XRO_IN,
        METRIC_IN,
        VENDOR_INFO,
        END;

    }

    private static enum State {
        INIT,
        REPORTED_IN,
        VENDOR_INFO_LIST,
        LOAD_BIN,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        RRO_IN,
        XRO_IN,
        OF_IN,
        CT_IN,
        END;

    }
}

