/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;

public abstract class AbstractPccIdReqObjectParser
implements ObjectSerializer,
ObjectParser {
    public static final int CLASS = 20;
    public static final int IPV4_TYPE = 1;
    public static final int IPV6_TYPE = 2;

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof PccIdReq, "Wrong instance of PCEPObject. Passed %s. Needed PccIdReqObject.", object.getClass());
        PccIdReq pccIdReq = (PccIdReq)object;
        if (pccIdReq.getIpAddress().getIpv4Address() != null) {
            ByteBuf body = Unpooled.buffer(4);
            ByteBufWriteUtil.writeIpv4Address(pccIdReq.getIpAddress().getIpv4Address(), body);
            ObjectUtil.formatSubobject(1, 20, object.isProcessingRule(), object.isIgnore(), body, buffer);
        } else if (pccIdReq.getIpAddress().getIpv6Address() != null) {
            ByteBuf body = Unpooled.buffer(16);
            ByteBufWriteUtil.writeIpv6Address(pccIdReq.getIpAddress().getIpv6Address(), body);
            ObjectUtil.formatSubobject(2, 20, object.isProcessingRule(), object.isIgnore(), body, buffer);
        }
    }
}

