/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId;

public abstract class AbstractPceIdObjectParser
implements ObjectParser,
ObjectSerializer {
    public static final int CLASS = 25;
    public static final int IPV4_TYPE = 1;
    public static final int IPV6_TYPE = 2;

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof PceId, "Wrong instance of PCEPObject. Passed %s. Needed PccIdReqObject.", object.getClass());
        PceId pceId = (PceId)object;
        if (pceId.getIpAddress().getIpv4Address() != null) {
            ByteBuf body = Unpooled.buffer(4);
            ByteBufWriteUtil.writeIpv4Address(pceId.getIpAddress().getIpv4Address(), body);
            ObjectUtil.formatSubobject(1, 25, object.isProcessingRule(), object.isIgnore(), body, buffer);
        } else if (pceId.getIpAddress().getIpv6Address() != null) {
            ByteBuf body = Unpooled.buffer(16);
            ByteBufWriteUtil.writeIpv6Address(pceId.getIpAddress().getIpv6Address(), body);
            ObjectUtil.formatSubobject(2, 25, object.isProcessingRule(), object.isIgnore(), body, buffer);
        }
    }
}

