/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.MetricBuilder;

public class PCEPMetricObjectParser
implements ObjectParser,
ObjectSerializer {
    public static final int CLASS = 6;
    public static final int TYPE = 1;
    private static final int FLAGS_SIZE = 8;
    private static final int METRIC_VALUE_F_LENGTH = 4;
    private static final int RESERVED = 2;
    private static final int C_FLAG_OFFSET = 6;
    private static final int B_FLAG_OFFSET = 7;
    private static final int SIZE = 8;

    @Override
    public Metric parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() != 8) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: " + 8 + ".");
        }
        bytes.skipBytes(2);
        BitArray flags = BitArray.valueOf(bytes.readByte());
        MetricBuilder builder = new MetricBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setBound(flags.get(7));
        builder.setComputed(flags.get(6));
        builder.setMetricType(bytes.readUnsignedByte());
        builder.setValue(new Float32(ByteArray.readBytes(bytes, 4)));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Metric, "Wrong instance of PCEPObject. Passed %s. Needed MetricObject.", object.getClass());
        Metric mObj = (Metric)object;
        ByteBuf body = Unpooled.buffer(8);
        body.writeZero(2);
        BitArray flags = new BitArray(8);
        flags.set(6, mObj.isComputed());
        flags.set(7, mObj.isBound());
        flags.toByteBuf(body);
        Preconditions.checkArgument(mObj.getMetricType() != null, "MetricType is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(mObj.getMetricType(), body);
        ByteBufWriteUtil.writeFloat32(mObj.getValue(), body);
        ObjectUtil.formatSubobject(1, 6, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

