/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.c.notification.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.c.notification.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;

public class PCEPNotificationObjectParser
extends AbstractObjectWithTlvsParser<CNotificationBuilder> {
    public static final int CLASS = 12;
    public static final int TYPE = 1;
    private static final int NT_F_OFFSET = 2;

    public PCEPNotificationObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public CNotification parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        CNotificationBuilder builder = new CNotificationBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        bytes.skipBytes(2);
        builder.setType(bytes.readUnsignedByte());
        builder.setValue(bytes.readUnsignedByte());
        this.parseTlvs(builder, bytes.slice());
        return builder.build();
    }

    @Override
    public void addTlv(CNotificationBuilder builder, Tlv tlv) {
        if (tlv instanceof OverloadDuration && builder.getType() == 2 && builder.getValue() == 1) {
            builder.setTlvs(new TlvsBuilder().setOverloadDuration((OverloadDuration)tlv).build());
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof CNotification, "Wrong instance of PCEPObject. Passed %s. Needed CNotificationObject.", object.getClass());
        CNotification notObj = (CNotification)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(2);
        Preconditions.checkArgument(notObj.getType() != null, "Type is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(notObj.getType(), body);
        Preconditions.checkArgument(notObj.getValue() != null, "Value is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(notObj.getValue(), body);
        this.serializeTlvs(notObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 12, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getOverloadDuration() != null) {
            this.serializeTlv(tlvs.getOverloadDuration(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    @Override
    protected final void addVendorInformationTlvs(CNotificationBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setTlvs(new TlvsBuilder(builder.getTlvs()).setVendorInformationTlv(tlvs).build());
        }
    }
}

