/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.object.OverloadBuilder;

public class PCEPOverloadObjectParser
implements ObjectParser,
ObjectSerializer {
    public static final int CLASS = 27;
    public static final int TYPE = 1;
    private static final int RESERVED = 1;
    private static final int FLAGS = 1;
    private static final int BODY_SIZE = 4;

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Overload, "Wrong instance of PCEPObject. Passed %s. Needed OverloadObject.", object.getClass());
        Overload overload = (Overload)object;
        ByteBuf body = Unpooled.buffer(4);
        body.writeZero(2);
        ByteBufWriteUtil.writeUnsignedShort(overload.getDuration(), body);
        ObjectUtil.formatSubobject(1, 27, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        OverloadBuilder builder = new OverloadBuilder();
        buffer.readBytes(2);
        builder.setDuration(buffer.readUnsignedShort());
        return builder.build();
    }
}

